(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     29956,        860]
NotebookOptionsPosition[     23922,        749]
NotebookOutlinePosition[     24734,        774]
CellTagsIndexPosition[     24691,        771]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Christoffel Symbols and Geodesic  Equation", "Subtitle",ExpressionUUID->"ae060b56-62db-4fc0-ab90-34e2622b0e3a"],

Cell[TextData[{
 "This is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program to compute the Christoffel  and the geodesic equations, starting \
from a given metric  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["g",
     FontSlant->"Italic"], "\[Alpha]\[Beta]"], TraditionalForm]],
  ExpressionUUID->"a0b4c64c-0669-452f-b222-aa330b9d65da"],
 ". The Christoffel symbols are calculated from the formula"
}], "Text",ExpressionUUID->"9edd2445-ef27-4b8a-b579-e81412274cf6"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Mu]\[Nu]"], "=", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{
      SuperscriptBox["g", "\[Lambda]\[Sigma]"], "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Mu]"], " ", 
        SubscriptBox["g", "\[Sigma]\[Nu]"]}], "+", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Nu]"], " ", 
        SubscriptBox["g", "\[Sigma]\[Mu]"]}], "-", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Sigma]"], " ", 
        SubscriptBox["g", "\[Mu]\[Nu]"]}]}], ")"}]}]}], TraditionalForm]],
  ExpressionUUID->"4d72f009-7500-40b1-ac19-51ecca8aa30f"],
 "\n\nwhere ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["g", "\[Lambda]\[Sigma]"], TraditionalForm]],ExpressionUUID->
  "d36b2817-450f-4017-aabe-9448ee2e8a55"],
 " is the matrix inverse of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", 
    RowBox[{"\[Lambda]\[Sigma]", " "}]], TraditionalForm]],ExpressionUUID->
  "11f36051-de21-474f-8d13-f655ea99e5c9"],
 "called the inverse metric. This is the  solution of the relation (8.19) and \
the notation for the inverse metric is standard [cf (20.17)]. The components \
of the geodesic equation are \n\n",
 StyleBox["d",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Alpha]"], TraditionalForm]],ExpressionUUID->
  "d2713574-220c-4d0f-8025-a5a92dc6dec2"],
 "/",
 StyleBox["d\[Tau]",
  FontSlant->"Italic"],
 " = - ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["\[CapitalGamma]", "\[Alpha]"], "\[Beta]\[Gamma]"], 
   TraditionalForm]],ExpressionUUID->"4c09545c-7f48-49d7-9c9b-29e38005cb9b"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Beta]"], TraditionalForm]],ExpressionUUID->
  "269a5262-895e-4f87-848e-c4f0f07dd72b"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Gamma]"], TraditionalForm]],ExpressionUUID->
  "b8c35665-0111-4ad7-847f-899d0ee6ba2d"],
 " ."
}], "Text",ExpressionUUID->"e4822065-755a-4fea-8f56-3ecc98877edc"],

Cell[TextData[{
 "You must input the covariant components of the metric tensor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "92003404-cd35-4627-a8bb-59b47fa4a751"],
 " by editing the relevant input line in this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook. You may also wish to change the names of the coordinates. The \
nonzero components of the above quantities are displayed as the output. "
}], "Text",ExpressionUUID->"c2eef415-c066-4c88-93e7-ff03f950e4ec"],

Cell[CellGroupData[{

Cell["Clearing the values of symbols:", "Subsubsection",ExpressionUUID->"8270c569-9ee5-449c-a6a0-3208be589cf0"],

Cell["\<\
First clear any values that may already have been assigned to the names of \
the various objects to be calculated. The names of the coordinates that you \
will use are also cleared.\
\>", "Text",ExpressionUUID->"0e897a29-b4e8-4da0-9075-e197920cdfa6"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "coord", ",", " ", "metric", ",", "inversemetric", ",", " ", "affine", ",", 
   "  ", "r", ",", " ", "\[Theta]", ",", " ", "\[Phi]", ",", " ", "t"}], 
  "]"}]], "Input",ExpressionUUID->"1b4f6838-84c9-4956-8da9-cf31aff09d2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting The Dimension ", "Subsubsection",ExpressionUUID->"d3bee7d4-9bb2-4709-be40-7b21e706ec06"],

Cell[TextData[{
 "The dimension ",
 StyleBox["n",
  FontWeight->"Bold"],
 " of the spacetime (or space) must be set:"
}], "Text",ExpressionUUID->"30e7ceb0-2802-4437-b2f4-9af370289704"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", "4"}]], "Input",ExpressionUUID->"fe168233-b285-4cb7-baff-06257a065115"],

Cell[BoxData["4"], "Output",ExpressionUUID->"bddec46a-aa6b-4ab6-9381-f5ef40011a8f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining a list of coordinates:", "Subsubsection",ExpressionUUID->"3d67ff20-54e2-4308-91cd-b1ca467b129c"],

Cell[TextData[{
 "The example given here is the wormhole metric (7.40). Note that for \
convenience ",
 StyleBox["t ",
  FontSlant->"Italic"],
 StyleBox["is denoted by ",
  FontVariations->{"CompatibilityType"->0}],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox["x", "4"],
    FontVariations->{"CompatibilityType"->0}], TraditionalForm]],
  ExpressionUUID->"a0c39fce-8275-4082-ae69-30c4f5e000e4"],
 " rather than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "0"], TraditionalForm]],ExpressionUUID->
  "50ced598-0b42-47ab-9acb-786e5f904360"],
 " and summations run from 1 to 4 rather than 0 to 3. "
}], "Text",ExpressionUUID->"03f6533e-102f-497a-92d8-58a481bea773"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"coord", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]", ",", "t"}], "}"}]}],
  FontWeight->"Bold"]], "Input",ExpressionUUID->"7b394efa-e481-46a3-a00e-\
51482fa4fec0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]", ",", "t"}], "}"}]], "Output",Ex\
pressionUUID->"2204a7c7-980a-4797-be0b-254e04661add"]
}, Open  ]],

Cell[TextData[{
 "You can change the names of the coordinates by simply editing the \
definition of ",
 StyleBox["coord",
  FontWeight->"Bold"],
 ", for example, to ",
 StyleBox["coord = {x, y, z, t}",
  FontWeight->"Bold"],
 ", when another set of coordinate names is more appropriate",
 "."
}], "Text",ExpressionUUID->"97695ace-7064-4403-8cfc-a1ca3c6415b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining the metric:", "Subsubsection",ExpressionUUID->"816542bd-e4e0-45f7-9b2f-f89ca74147d1"],

Cell["\<\
Input the metric as a list of lists, i.e., as a matrix. You can input the \
components of any metric here, but you must specify them as explicit \
functions of the coordinates.\
\>", "Text",ExpressionUUID->"5528aef8-12bf-4936-8abf-6f7280174ffb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"r", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}], 
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "^", "2"}]}], ",", "0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]], "Input",ExpressionUUID->\
"d7eb5b60-6aae-4742-aac1-a39a36d5ac20"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["r", "2"]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", "0"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",ExpressionUUID->\
"ffa446a1-c539-43cb-b4bf-ac2ba2509c38"]
}, Open  ]],

Cell["You can also display this in matrix form:", "Text",ExpressionUUID->"fc63331d-8f19-4cd8-bb96-c5b862457e8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "//", "MatrixForm"}]], "Input",ExpressionUUID->"cba883a7-f84c-4d2d-a5c4-791e3a62a558"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0"},
     {"0", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["r", "2"]}], "0", "0"},
     {"0", "0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "0"},
     {"0", "0", "0", 
      RowBox[{"-", "1"}]}
    }], "\[NoBreak]", ")"}],
  MatrixForm[#]& ]], "Output",ExpressionUUID->"e45fdf38-e11d-4ab4-9831-\
4ce74a414689"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Note:", "Subsubsection",ExpressionUUID->"fa26f084-adda-4238-a4f9-fb86f557b89e"],

Cell[TextData[{
 "It is important not to use the symbols, ",
 StyleBox["i",
  FontWeight->"Bold"],
 ", ",
 StyleBox["j",
  FontWeight->"Bold"],
 ", ",
 StyleBox["k",
  FontWeight->"Bold"],
 ", ",
 StyleBox["l",
  FontWeight->"Bold"],
 ", ",
 StyleBox["n,",
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 " or ",
 StyleBox["s  ",
  FontWeight->"Bold"],
 "as constants or coordinates in the metric that you specify above. The \
reason is that  the first four of those symbols are used as summation or \
table indices in the calculations done below. The last is the dimension of \
the space. "
}], "Text",ExpressionUUID->"4a2c2de1-f726-4d46-94aa-4e38575919be"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the inverse metric:", "Subsubsection",ExpressionUUID->"8589076b-dc08-44e2-886e-0a7f7379c61d"],

Cell["The inverse metric is obtained through matrix inversion.", "Text",ExpressionUUID->"5a67de42-d885-4dd3-8c82-1cfd4955658b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inversemetric", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Inverse", "[", "metric", "]"}], "]"}]}]], "Input",ExpressionUUID->\
"861d87e3-51bc-4db0-96e3-1e0e87ca5229"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["r", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["r", "2"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",ExpressionUUID->\
"2d4312db-3423-4b36-9d35-6e1c89b9165b"]
}, Open  ]],

Cell["The inverse metric can also be displayed in matrix form:", "Text",ExpressionUUID->"0cda4996-bdb5-4097-aada-3c61291a8e6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inversemetric", "//", "MatrixForm"}]], "Input",ExpressionUUID->"6950b1a9-4d8d-4b5c-abac-f1e2bb5a2c63"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0"},
     {"0", 
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["r", "2"]}]], "0", "0"},
     {"0", "0", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["r", "2"]}]], "0"},
     {"0", "0", "0", 
      RowBox[{"-", "1"}]}
    }], "\[NoBreak]", ")"}],
  MatrixForm[#]& ]], "Output",ExpressionUUID->"3fa5fae5-66e2-4b7a-ad16-\
a02d44023756"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the affine connection:", "Subsubsection",ExpressionUUID->"7d89f810-63d6-45bf-bbd2-eb182fa10586"],

Cell[TextData[{
 "The calculation of the components of the affine connection is done by \
transcribing the definition given earlier into the notation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions ",
 StyleBox["D",
  FontWeight->"Bold"],
 " for taking partial derivatives, ",
 StyleBox["Sum",
  FontWeight->"Bold"],
 " for summing over repeated indices, ",
 StyleBox["Table",
  FontWeight->"Bold"],
 " for forming a list of components, and ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " for simplifying the result."
}], "Text",ExpressionUUID->"946f39a7-0c9c-47c7-aa8a-9e40297025a1"],

Cell[BoxData[
 RowBox[{"affine", ":=", 
  RowBox[{"affine", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], "*", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"inversemetric", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "s"}], "]"}], "]"}], ")"}], "*", 
          "\[IndentingNewLine]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"s", ",", "j"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "k", "]"}], "]"}]}], " ", "]"}], "+", 
            "\[IndentingNewLine]", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"s", ",", "k"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "j", "]"}], "]"}]}], " ", "]"}], "-", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"j", ",", "k"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "s", "]"}], "]"}]}], " ", "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
    "]"}]}]}]], "Input",ExpressionUUID->"ea3c740a-fc67-489a-95e4-\
d11b82e387da"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying the affine connection:", "Subsubsection",ExpressionUUID->"7373c492-4da3-4d8c-b53e-4d9cdfcfaddf"],

Cell["\<\
The nonzero components of the affine connections are displayed below. You \
need not follow the details of constructing the functions that we use for \
that purpose. Because the affine connection is symmetric under interchange of \
the last two indices, only the independent components are displayed.\
\>", "Text",ExpressionUUID->"31a46c00-8015-4966-850f-6bd42d9b8e04"],

Cell[BoxData[
 RowBox[{"listaffine", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"affine", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", "0"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", 
        RowBox[{"affine", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    " ", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "j"}], "}"}]}], "]"}]}]], "Input",ExpressionU\
UID->"e42bade5-c060-42a2-ac89-84265732d5de"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listaffine", "]"}], ",", "Null"}], "]"}], ",",
      "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",ExpressionUUID->\
"b58273e1-915b-499d-896d-9279b5442ffe"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\[CapitalGamma][1, 2, 2]\"\>", 
     RowBox[{"-", "r"}]},
    {"\<\"\[CapitalGamma][1, 3, 3]\"\>", 
     RowBox[{
      RowBox[{"-", "r"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]},
    {"\<\"\[CapitalGamma][2, 2, 1]\"\>", 
     FractionBox["r", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"\[CapitalGamma][2, 3, 3]\"\>", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
    {"\<\"\[CapitalGamma][3, 3, 1]\"\>", 
     FractionBox["r", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"\[CapitalGamma][3, 3, 2]\"\>", 
     RowBox[{"Cot", "[", "\[Theta]", "]"}]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[1.4]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  TableForm[#, TableSpacing -> {2, 2}]& ]], "Output",ExpressionUUID->\
"9d139d1e-40e4-4581-80d4-22014bd5f7aa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the geodesic equations:", "Subsubsection",ExpressionUUID->"4579e506-ed98-4ebc-abf4-a27c52cefbab"],

Cell[TextData[{
 "The geodesic equations are calculated by asking  ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 StyleBox["to carry out the sum -",
  FontVariations->{"CompatibilityType"->0}],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["\[CapitalGamma]", "\[Alpha]"], "\[Beta]\[Gamma]"], 
   TraditionalForm]],ExpressionUUID->"5032ea92-da6b-4617-b827-7e3b423978c2"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Beta]"], TraditionalForm]],ExpressionUUID->
  "b68fbb86-f92f-48d4-bb1d-62bc4c0202d0"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Gamma]"], TraditionalForm]],ExpressionUUID->
  "2c88cb01-904d-48d9-9e56-98191dd7d9e6"],
 ",  where ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Alpha]"], TraditionalForm]],ExpressionUUID->
  "a93015fe-352e-4188-a409-479270c66d5c"],
 " are the components of the four-velocity.  (This gives the derivitive of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Alpha]"], TraditionalForm]],ExpressionUUID->
  "b35b3ac8-7f40-466b-b934-ff5555d4d3bc"],
 " with respect to proper time  \[Tau].  (This is replaced by  ",
 StyleBox["s",
  FontSlant->"Italic"],
 "  if the geodesics are spacelike.)"
}], "Text",ExpressionUUID->"d2d74074-17c5-4bd9-8192-29321819fbd1"],

Cell[BoxData[
 RowBox[{"geodesic", ":=", 
  RowBox[{"geodesic", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"affine", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], 
          RowBox[{"u", "[", "j", "]"}], 
          RowBox[{"u", "[", "k", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]}]}]], "Input",\
ExpressionUUID->"4546cca6-2350-4de3-81e4-3b4368062f2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying the geodesic equations:", "Subsubsection",ExpressionUUID->"f2e9ccff-61fa-4ccc-b079-77c4ba739dca"],

Cell[BoxData[
 RowBox[{"listgeodesic", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<d/d\[Tau]\>\"", 
       RowBox[{"ToString", "[", 
        RowBox[{"u", "[", "i", "]"}], "]"}]}], ",", "\"\<=\>\"", ",", 
      RowBox[{"geodesic", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}]], "Input",ExpressionU\
UID->"cb32e86b-829e-4613-8e78-6f7c216b42cd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"listgeodesic", ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", "2", "}"}]}]}], "]"}]], "Input",ExpressionUUID->"eecab278-\
733e-4c4d-b344-0325336afcf9"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"\<\"d/d\[Tau]\"\>", " ", "\<\"u[1]\"\>"}], "\<\"=\"\>", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"u", "[", "2", "]"}], "2"], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"u", "[", "3", "]"}], "2"]}]}], ")"}]}]},
    {
     RowBox[{"\<\"d/d\[Tau]\"\>", " ", "\<\"u[2]\"\>"}], "\<\"=\"\>", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"u", "[", "1", "]"}], " ", 
         RowBox[{"u", "[", "2", "]"}]}], 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["r", "2"]}]]}], "+", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"u", "[", "3", "]"}], "2"]}]}]},
    {
     RowBox[{"\<\"d/d\[Tau]\"\>", " ", "\<\"u[3]\"\>"}], "\<\"=\"\>", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"u", "[", "1", "]"}], " ", 
         RowBox[{"u", "[", "3", "]"}]}], 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["r", "2"]}]]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"u", "[", "2", "]"}], " ", 
       RowBox[{"u", "[", "3", "]"}]}]}]},
    {
     RowBox[{"\<\"d/d\[Tau]\"\>", " ", "\<\"u[4]\"\>"}], "\<\"=\"\>", "0"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  TableForm[#, TableSpacing -> {2}]& ]], "Output",ExpressionUUID->"b3d338d6-\
c04c-40bc-adfa-ae42d407db24"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Acknowledgment", "Subsubsection",ExpressionUUID->"9a3d2695-c35b-4c4e-8714-79ddb80fa1ed"],

Cell[TextData[{
 "This program was adapted from the notebook ",
 StyleBox["Curvature and the Einstein ",
  FontSlant->"Italic"],
 "equation kindly written by ",
 StyleBox["Leonard Parker ",
  FontSlant->"Italic"],
 StyleBox[" especially for this text. ",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",ExpressionUUID->"bbde29a1-ef0d-4520-bef4-54b0174836fa"]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{759, 616},
WindowMargins->{{221, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792},
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "home", "cosmic", 
   "hartle", "131book", "math"}, "wh.ps", CharacterEncoding -> "ISO8859-1"]},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b2167e98-0acd-481f-b86f-fb28b48a79ec"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 117, 0, 79, "Subtitle",ExpressionUUID->"ae060b56-62db-4fc0-ab90-34e2622b0e3a"],
Cell[700, 24, 495, 13, 124, "Text",ExpressionUUID->"9edd2445-ef27-4b8a-b579-e81412274cf6"],
Cell[1198, 39, 2063, 60, 303, "Text",ExpressionUUID->"e4822065-755a-4fea-8f56-3ecc98877edc"],
Cell[3264, 101, 537, 11, 193, "Text",ExpressionUUID->"c2eef415-c066-4c88-93e7-ff03f950e4ec"],
Cell[CellGroupData[{
Cell[3826, 116, 111, 0, 67, "Subsubsection",ExpressionUUID->"8270c569-9ee5-449c-a6a0-3208be589cf0"],
Cell[3940, 118, 260, 4, 122, "Text",ExpressionUUID->"0e897a29-b4e8-4da0-9075-e197920cdfa6"],
Cell[4203, 124, 275, 5, 78, "Input",ExpressionUUID->"1b4f6838-84c9-4956-8da9-cf31aff09d2a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4515, 134, 102, 0, 67, "Subsubsection",ExpressionUUID->"d3bee7d4-9bb2-4709-be40-7b21e706ec06"],
Cell[4620, 136, 184, 5, 53, "Text",ExpressionUUID->"30e7ceb0-2802-4437-b2f4-9af370289704"],
Cell[CellGroupData[{
Cell[4829, 145, 104, 1, 46, "Input",ExpressionUUID->"fe168233-b285-4cb7-baff-06257a065115"],
Cell[4936, 148, 83, 0, 52, "Output",ExpressionUUID->"bddec46a-aa6b-4ab6-9381-f5ef40011a8f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5068, 154, 111, 0, 67, "Subsubsection",ExpressionUUID->"3d67ff20-54e2-4308-91cd-b1ca467b129c"],
Cell[5182, 156, 683, 19, 123, "Text",ExpressionUUID->"03f6533e-102f-497a-92d8-58a481bea773"],
Cell[CellGroupData[{
Cell[5890, 179, 236, 6, 46, "Input",ExpressionUUID->"7b394efa-e481-46a3-a00e-51482fa4fec0"],
Cell[6129, 187, 162, 3, 52, "Output",ExpressionUUID->"2204a7c7-980a-4797-be0b-254e04661add"]
}, Open  ]],
Cell[6306, 193, 359, 10, 122, "Text",ExpressionUUID->"97695ace-7064-4403-8cfc-a1ca3c6415b8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6702, 208, 100, 0, 67, "Subsubsection",ExpressionUUID->"816542bd-e4e0-45f7-9b2f-f89ca74147d1"],
Cell[6805, 210, 255, 4, 122, "Text",ExpressionUUID->"5528aef8-12bf-4936-8abf-6f7280174ffb"],
Cell[CellGroupData[{
Cell[7085, 218, 783, 24, 78, "Input",ExpressionUUID->"d7eb5b60-6aae-4742-aac1-a39a36d5ac20"],
Cell[7871, 244, 744, 23, 90, "Output",ExpressionUUID->"ffa446a1-c539-43cb-b4bf-ac2ba2509c38"]
}, Open  ]],
Cell[8630, 270, 112, 0, 53, "Text",ExpressionUUID->"fc63331d-8f19-4cd8-bb96-c5b862457e8a"],
Cell[CellGroupData[{
Cell[8767, 274, 119, 1, 46, "Input",ExpressionUUID->"cba883a7-f84c-4d2d-a5c4-791e3a62a558"],
Cell[8889, 277, 610, 20, 137, "Output",ExpressionUUID->"e45fdf38-e11d-4ab4-9831-4ce74a414689"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9548, 303, 85, 0, 67, "Subsubsection",ExpressionUUID->"fa26f084-adda-4238-a4f9-fb86f557b89e"],
Cell[9636, 305, 678, 24, 191, "Text",ExpressionUUID->"4a2c2de1-f726-4d46-94aa-4e38575919be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10351, 334, 111, 0, 67, "Subsubsection",ExpressionUUID->"8589076b-dc08-44e2-886e-0a7f7379c61d"],
Cell[10465, 336, 127, 0, 53, "Text",ExpressionUUID->"5a67de42-d885-4dd3-8c82-1cfd4955658b"],
Cell[CellGroupData[{
Cell[10617, 340, 193, 4, 46, "Input",ExpressionUUID->"861d87e3-51bc-4db0-96e3-1e0e87ca5229"],
Cell[10813, 346, 735, 22, 130, "Output",ExpressionUUID->"2d4312db-3423-4b36-9d35-6e1c89b9165b"]
}, Open  ]],
Cell[11563, 371, 127, 0, 53, "Text",ExpressionUUID->"0cda4996-bdb5-4097-aada-3c61291a8e6c"],
Cell[CellGroupData[{
Cell[11715, 375, 126, 1, 46, "Input",ExpressionUUID->"6950b1a9-4d8d-4b5c-abac-f1e2bb5a2c63"],
Cell[11844, 378, 605, 20, 157, "Output",ExpressionUUID->"3fa5fae5-66e2-4b7a-ad16-a02d44023756"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12498, 404, 114, 0, 67, "Subsubsection",ExpressionUUID->"7d89f810-63d6-45bf-bbd2-eb182fa10586"],
Cell[12615, 406, 676, 21, 226, "Text",ExpressionUUID->"946f39a7-0c9c-47c7-aa8a-9e40297025a1"],
Cell[13294, 429, 1855, 51, 295, "Input",ExpressionUUID->"ea3c740a-fc67-489a-95e4-d11b82e387da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15186, 485, 113, 0, 67, "Subsubsection",ExpressionUUID->"7373c492-4da3-4d8c-b53e-4d9cdfcfaddf"],
Cell[15302, 487, 379, 5, 191, "Text",ExpressionUUID->"31a46c00-8015-4966-850f-6bd42d9b8e04"],
Cell[15684, 494, 921, 27, 140, "Input",ExpressionUUID->"e42bade5-c060-42a2-ac89-84265732d5de"],
Cell[CellGroupData[{
Cell[16630, 525, 421, 12, 109, "Input",ExpressionUUID->"b58273e1-915b-499d-896d-9279b5442ffe"],
Cell[17054, 539, 1243, 36, 245, "Output",ExpressionUUID->"9d139d1e-40e4-4581-80d4-22014bd5f7aa"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18346, 581, 115, 0, 67, "Subsubsection",ExpressionUUID->"4579e506-ed98-4ebc-abf4-a27c52cefbab"],
Cell[18464, 583, 1254, 33, 194, "Text",ExpressionUUID->"d2d74074-17c5-4bd9-8192-29321819fbd1"],
Cell[19721, 618, 794, 22, 202, "Input",ExpressionUUID->"4546cca6-2350-4de3-81e4-3b4368062f2a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20552, 645, 114, 0, 67, "Subsubsection",ExpressionUUID->"f2e9ccff-61fa-4ccc-b079-77c4ba739dca"],
Cell[20669, 647, 483, 13, 109, "Input",ExpressionUUID->"cb32e86b-829e-4613-8e78-6f7c216b42cd"],
Cell[CellGroupData[{
Cell[21177, 664, 219, 5, 46, "Input",ExpressionUUID->"eecab278-733e-4c4d-b344-0325336afcf9"],
Cell[21399, 671, 1983, 57, 185, "Output",ExpressionUUID->"b3d338d6-c04c-40bc-adfa-ae42d407db24"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23431, 734, 95, 0, 67, "Subsubsection",ExpressionUUID->"9a3d2695-c35b-4c4e-8714-79ddb80fa1ed"],
Cell[23529, 736, 365, 9, 122, "Text",ExpressionUUID->"bbde29a1-ef0d-4520-bef4-54b0174836fa"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

