(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     27825,        788]
NotebookOptionsPosition[     21797,        677]
NotebookOutlinePosition[     22608,        702]
CellTagsIndexPosition[     22565,        699]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Christoffel Symbols and Geodesic  Equation", "Subtitle",ExpressionUUID->"6125aaf3-0053-4506-ace8-b9c57f9e6b44"],

Cell[TextData[{
 "This is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program to compute the Christoffel  and the geodesic equations, starting \
from a given metric  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["g",
     FontSlant->"Italic"], "\[Alpha]\[Beta]"], TraditionalForm]],
  ExpressionUUID->"de92edfe-a93e-4e59-a872-8d4ca5c312af"],
 ". The Christoffel symbols are calculated from the formula"
}], "Text",ExpressionUUID->"7eba7313-6a6d-4223-bfb6-c7a61ecafb1f"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Mu]\[Nu]"], "=", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{
      SuperscriptBox["g", "\[Lambda]\[Sigma]"], "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Mu]"], " ", 
        SubscriptBox["g", "\[Sigma]\[Nu]"]}], "+", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Nu]"], " ", 
        SubscriptBox["g", "\[Sigma]\[Mu]"]}], "-", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Sigma]"], " ", 
        SubscriptBox["g", "\[Mu]\[Nu]"]}]}], ")"}]}]}], TraditionalForm]],
  ExpressionUUID->"a8324fab-3725-49a6-8ca1-6d818d021d18"],
 "\n\nwhere ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["g", "\[Lambda]\[Sigma]"], TraditionalForm]],ExpressionUUID->
  "7137debf-0f90-43a4-8bf3-6436ea7f7fba"],
 " is the matrix inverse of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", 
    RowBox[{"\[Lambda]\[Sigma]", " "}]], TraditionalForm]],ExpressionUUID->
  "494b6dd1-b347-4eab-b0fd-78fae5df1b28"],
 "called the inverse metric. This is the  solution of the relation (8.19) and \
the notation for the inverse metric is standard [cf (20.17)]. The components \
of the geodesic equation are \n\n",
 StyleBox["d",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Alpha]"], TraditionalForm]],ExpressionUUID->
  "8d1bf865-3874-4b46-802f-fe84d8567169"],
 "/",
 StyleBox["d\[Tau]",
  FontSlant->"Italic"],
 " = - ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["\[CapitalGamma]", "\[Alpha]"], "\[Beta]\[Gamma]"], 
   TraditionalForm]],ExpressionUUID->"374b3c24-ab6a-4510-a201-25fa753877d0"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Beta]"], TraditionalForm]],ExpressionUUID->
  "04a39ebe-922f-4a05-93ba-b958d09dc7b7"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Gamma]"], TraditionalForm]],ExpressionUUID->
  "a2cd1ea9-972a-4233-afa1-1c76b7699d54"],
 " ."
}], "Text",ExpressionUUID->"01e027dc-4dca-47da-a08e-b8f07ccbd195"],

Cell[TextData[{
 "You must input the covariant components of the metric tensor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "bb17445a-f46f-4387-a947-607027e797a0"],
 " by editing the relevant input line in this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook. You may also wish to change the names of the coordinates. The \
nonzero components of the above quantities are displayed as the output. "
}], "Text",ExpressionUUID->"c5f6f071-12d3-412e-8137-9a4fbec3dc68"],

Cell[CellGroupData[{

Cell["Clearing the values of symbols:", "Subsubsection",ExpressionUUID->"a500a8b8-fc6b-4f62-9e79-fc928abec442"],

Cell["\<\
First clear any values that may already have been assigned to the names of \
the various objects to be calculated. The names of the coordinates that you \
will use are also cleared.\
\>", "Text",ExpressionUUID->"e6b6dec0-f61b-4b4d-8dcc-8efca6dee2cb"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "coord", ",", " ", "metric", ",", "inversemetric", ",", " ", "affine", ",", 
   "  ", "r", ",", " ", "\[Theta]", ",", " ", "\[Phi]", ",", " ", "t"}], 
  "]"}]], "Input",ExpressionUUID->"abf897e6-452e-41c8-90fb-a7570db96200"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting The Dimension ", "Subsubsection",ExpressionUUID->"0c8c7097-d1fc-4278-8c2c-bc194a232bde"],

Cell[TextData[{
 "The dimension ",
 StyleBox["n",
  FontWeight->"Bold"],
 " of the spacetime (or space) must be set:"
}], "Text",ExpressionUUID->"1567f89a-011f-4625-9585-8ddef45f4737"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", "2"}]], "Input",
 CellChangeTimes->{{3.8103244900841703`*^9, 3.8103244944057426`*^9}, {
  3.857726575296522*^9, 3.857726576938611*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"2ce3b292-c27d-4af8-9282-7f3c15b5e049"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.857726579950062*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"2e38a661-e89c-4cdf-a08c-7ccf9dab7fa5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining a list of coordinates:", "Subsubsection",ExpressionUUID->"79f17e88-9a24-4a25-96f7-84b51937eea7"],

Cell[TextData[{
 "The example given here is the wormhole metric (7.40). Note that for \
convenience ",
 StyleBox["t ",
  FontSlant->"Italic"],
 StyleBox["is denoted by ",
  FontVariations->{"CompatibilityType"->0}],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox["x", "4"],
    FontVariations->{"CompatibilityType"->0}], TraditionalForm]],
  ExpressionUUID->"0b165c4f-a7ca-4442-abb0-2dd49ec1e999"],
 " rather than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "0"], TraditionalForm]],ExpressionUUID->
  "49aef013-fbe3-45af-8136-188fce16efe5"],
 " and summations run from 1 to 4 rather than 0 to 3. "
}], "Text",ExpressionUUID->"605b38c0-f382-4153-8eeb-559cbad52bc7"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"coord", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]"}], "}"}]}],
  FontWeight->"Bold"]], "Input",
 CellChangeTimes->{{3.8103245053855658`*^9, 3.810324506387878*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"849e058e-8ac9-4da0-9644-72b2620dd375"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "\[Theta]"}], "}"}]], "Output",
 CellChangeTimes->{3.857726594485496*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"dc2da90c-2787-4103-9560-5d2ec62a0873"]
}, Open  ]],

Cell[TextData[{
 "You can change the names of the coordinates by simply editing the \
definition of ",
 StyleBox["coord",
  FontWeight->"Bold"],
 ", for example, to ",
 StyleBox["coord = {x, y, z, t}",
  FontWeight->"Bold"],
 ", when another set of coordinate names is more appropriate",
 "."
}], "Text",ExpressionUUID->"c78daf5a-6597-4b5a-97d0-265c34c908b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining the metric:", "Subsubsection",ExpressionUUID->"671f5fdf-1931-41cd-b8d2-81d129847d8f"],

Cell["\<\
Input the metric as a list of lists, i.e., as a matrix. You can input the \
components of any metric here, but you must specify them as explicit \
functions of the coordinates.\
\>", "Text",ExpressionUUID->"01c2ba35-b61a-48e6-9e56-37098f220766"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"r", "^", "2"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8103247498258944`*^9, 3.810324770774022*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"51907da9-de63-4684-8059-1ecab5db1e79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SuperscriptBox["r", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.857726627175028*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"296de9fe-b658-4862-8c6d-9fd177b05257"]
}, Open  ]],

Cell["You can also display this in matrix form:", "Text",ExpressionUUID->"335bfe74-c74b-4b94-9aa3-b9e1f6492824"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"39df8ce5-486f-419c-b49d-2add46687883"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0"},
     {"0", 
      SuperscriptBox["r", "2"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.857726640768012*^9},
 CellLabel->
  "Out[4]//MatrixForm=",ExpressionUUID->"2bb9ac14-4723-4b90-86f8-\
f6c71f435529"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Note:", "Subsubsection",ExpressionUUID->"18ffbdb6-293b-4b3b-a67a-8d359267b5a9"],

Cell[TextData[{
 "It is important not to use the symbols, ",
 StyleBox["i",
  FontWeight->"Bold"],
 ", ",
 StyleBox["j",
  FontWeight->"Bold"],
 ", ",
 StyleBox["k",
  FontWeight->"Bold"],
 ", ",
 StyleBox["l",
  FontWeight->"Bold"],
 ", ",
 StyleBox["n,",
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 " or ",
 StyleBox["s  ",
  FontWeight->"Bold"],
 "as constants or coordinates in the metric that you specify above. The \
reason is that  the first four of those symbols are used as summation or \
table indices in the calculations done below. The last is the dimension of \
the space. "
}], "Text",ExpressionUUID->"85b70ca5-1558-40cd-b56f-9b119fbe96da"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the inverse metric:", "Subsubsection",ExpressionUUID->"c578828e-40ee-4062-b377-ac857cf9c762"],

Cell["The inverse metric is obtained through matrix inversion.", "Text",ExpressionUUID->"22bcb7fd-f7fa-4c37-a2e2-f85f1849915b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inversemetric", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Inverse", "[", "metric", "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"61c6fd16-125e-41f0-a38f-cf31549f39da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      SuperscriptBox["r", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.857726659895089*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"eb3d1975-5e20-4a63-90f3-728088310645"]
}, Open  ]],

Cell["The inverse metric can also be displayed in matrix form:", "Text",ExpressionUUID->"92bd1fba-9dd4-4e79-ad6f-78a7eabf68d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inversemetric", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"7586007f-337c-4ca3-80e5-fc23e41c9c06"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0"},
     {"0", 
      FractionBox["1", 
       SuperscriptBox["r", "2"]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.857726681145776*^9},
 CellLabel->
  "Out[6]//MatrixForm=",ExpressionUUID->"2111982f-dd76-4565-9236-\
a6b7f51ad19e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the affine connection:", "Subsubsection",ExpressionUUID->"e07962c2-3efd-4613-981c-bed62deb4171"],

Cell[TextData[{
 "The calculation of the components of the affine connection is done by \
transcribing the definition given earlier into the notation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions ",
 StyleBox["D",
  FontWeight->"Bold"],
 " for taking partial derivatives, ",
 StyleBox["Sum",
  FontWeight->"Bold"],
 " for summing over repeated indices, ",
 StyleBox["Table",
  FontWeight->"Bold"],
 " for forming a list of components, and ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " for simplifying the result."
}], "Text",ExpressionUUID->"1bf55e2f-9648-4c26-8938-5f7f59f32cf4"],

Cell[BoxData[
 RowBox[{"affine", ":=", 
  RowBox[{"affine", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], "*", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"inversemetric", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "s"}], "]"}], "]"}], ")"}], "*", 
          "\[IndentingNewLine]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"s", ",", "j"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "k", "]"}], "]"}]}], " ", "]"}], "+", 
            "\[IndentingNewLine]", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"s", ",", "k"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "j", "]"}], "]"}]}], " ", "]"}], "-", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"j", ",", "k"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "s", "]"}], "]"}]}], " ", "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
    "]"}]}]}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"760578ee-d4f8-4cfc-8d4e-c31909b1a3f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying the affine connection:", "Subsubsection",ExpressionUUID->"cd73a828-5ec7-404d-bf5d-b2f23d1c7182"],

Cell["\<\
The nonzero components of the affine connections are displayed below. You \
need not follow the details of constructing the functions that we use for \
that purpose. Because the affine connection is symmetric under interchange of \
the last two indices, only the independent components are displayed.\
\>", "Text",ExpressionUUID->"e490e73f-92da-40a8-bcc8-0a4f626e75ff"],

Cell[BoxData[
 RowBox[{"listaffine", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"affine", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", "0"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", 
        RowBox[{"affine", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    " ", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "j"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"e5c0914c-1de7-4c39-ae8c-c13787145d72"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listaffine", "]"}], ",", "Null"}], "]"}], ",",
      "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"10802c67-9ca6-490e-8a9d-7beed400ae29"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\[CapitalGamma][1, 2, 2]\"\>", 
     RowBox[{"-", "r"}]},
    {"\<\"\[CapitalGamma][2, 2, 1]\"\>", 
     FractionBox["1", "r"]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[1.4]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableSpacing -> {2, 2}]]]], "Output",
 CellChangeTimes->{3.857726807623479*^9},
 CellLabel->
  "Out[9]//TableForm=",ExpressionUUID->"e85f5348-8260-42f9-8180-ffd57558283a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the geodesic equations:", "Subsubsection",ExpressionUUID->"78cba0f2-db6f-480d-bb7b-e6eab3ba8140"],

Cell[TextData[{
 "The geodesic equations are calculated by asking  ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 StyleBox["to carry out the sum -",
  FontVariations->{"CompatibilityType"->0}],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["\[CapitalGamma]", "\[Alpha]"], "\[Beta]\[Gamma]"], 
   TraditionalForm]],ExpressionUUID->"f0833236-fa7e-4d23-9878-02139452c2b3"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Beta]"], TraditionalForm]],ExpressionUUID->
  "11a681d2-ab4e-40d1-bc46-20b99496d069"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Gamma]"], TraditionalForm]],ExpressionUUID->
  "866274e0-c881-4120-8f6f-fb7470587c9f"],
 ",  where ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Alpha]"], TraditionalForm]],ExpressionUUID->
  "188693ed-d40e-4dab-b486-6eb44a76a836"],
 " are the components of the four-velocity.  (This gives the derivative of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["u", "\[Alpha]"], TraditionalForm]],ExpressionUUID->
  "2d2a063f-9a61-4fb0-9cea-36697d711d4b"],
 " with respect to proper time  \[Tau].  (This is replaced by  ",
 StyleBox["s",
  FontSlant->"Italic"],
 "  if the geodesics are spacelike.)"
}], "Text",
 CellChangeTimes->{{3.85767709241193*^9, 
  3.857677092648426*^9}},ExpressionUUID->"534b7e86-3484-4b31-8f90-\
1a8c408f26c3"],

Cell[BoxData[
 RowBox[{"geodesic", ":=", 
  RowBox[{"geodesic", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"affine", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], 
          RowBox[{"u", "[", "j", "]"}], 
          RowBox[{"u", "[", "k", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}]}]}]], "Input",\

 CellLabel->"In[11]:=",ExpressionUUID->"393f3dcb-cce1-4c2e-85f8-12b9895aeb2d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying the geodesic equations:", "Subsubsection",ExpressionUUID->"e795eede-bfdd-4474-921f-85862e2308dd"],

Cell[BoxData[
 RowBox[{"listgeodesic", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<d/d\[Tau]\>\"", 
       RowBox[{"ToString", "[", 
        RowBox[{"u", "[", "i", "]"}], "]"}]}], ",", "\"\<=\>\"", ",", 
      RowBox[{"geodesic", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"3fb5d668-260a-48ef-ab37-d10ef2a936be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"listgeodesic", ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", "2", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"f1666e5b-a6be-4088-ac19-58b6af6db608"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"\<\"d/d\[Tau]\"\>", " ", "\<\"u[1]\"\>"}], "\<\"=\"\>", 
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"u", "[", "2", "]"}], "2"]}]},
    {
     RowBox[{"\<\"d/d\[Tau]\"\>", " ", "\<\"u[2]\"\>"}], "\<\"=\"\>", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"u", "[", "1", "]"}], " ", 
        RowBox[{"u", "[", "2", "]"}]}], "r"]}]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableSpacing -> {2}]]]], "Output",
 CellChangeTimes->{3.857726907422908*^9},
 CellLabel->
  "Out[13]//TableForm=",ExpressionUUID->"4d72d4e5-d4bf-4311-a134-\
3ae2dbcbfa5f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Acknowledgment", "Subsubsection",ExpressionUUID->"443c5bca-c6d5-4ee6-91e6-d8181dd38872"],

Cell[TextData[{
 "This program was adapted from the notebook ",
 StyleBox["Curvature and the Einstein ",
  FontSlant->"Italic"],
 "equation kindly written by ",
 StyleBox["Leonard Parker ",
  FontSlant->"Italic"],
 StyleBox[" especially for this text. ",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",ExpressionUUID->"3e26d923-811b-49ef-9d7a-27d4abd6fde0"]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{759, 606},
WindowMargins->{{30, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792},
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "home", "cosmic", 
   "hartle", "131book", "math"}, "wh.ps", CharacterEncoding -> "ISO8859-1"]},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d45443c4-ec70-4c59-b62b-9409447e91e3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 117, 0, 79, "Subtitle",ExpressionUUID->"6125aaf3-0053-4506-ace8-b9c57f9e6b44"],
Cell[700, 24, 495, 13, 124, "Text",ExpressionUUID->"7eba7313-6a6d-4223-bfb6-c7a61ecafb1f"],
Cell[1198, 39, 2063, 60, 303, "Text",ExpressionUUID->"01e027dc-4dca-47da-a08e-b8f07ccbd195"],
Cell[3264, 101, 537, 11, 193, "Text",ExpressionUUID->"c5f6f071-12d3-412e-8137-9a4fbec3dc68"],
Cell[CellGroupData[{
Cell[3826, 116, 111, 0, 67, "Subsubsection",ExpressionUUID->"a500a8b8-fc6b-4f62-9e79-fc928abec442"],
Cell[3940, 118, 260, 4, 122, "Text",ExpressionUUID->"e6b6dec0-f61b-4b4d-8dcc-8efca6dee2cb"],
Cell[4203, 124, 275, 5, 78, "Input",ExpressionUUID->"abf897e6-452e-41c8-90fb-a7570db96200"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4515, 134, 102, 0, 67, "Subsubsection",ExpressionUUID->"0c8c7097-d1fc-4278-8c2c-bc194a232bde"],
Cell[4620, 136, 184, 5, 53, "Text",ExpressionUUID->"1567f89a-011f-4625-9585-8ddef45f4737"],
Cell[CellGroupData[{
Cell[4829, 145, 246, 4, 46, "Input",ExpressionUUID->"2ce3b292-c27d-4af8-9282-7f3c15b5e049"],
Cell[5078, 151, 148, 2, 52, "Output",ExpressionUUID->"2e38a661-e89c-4cdf-a08c-7ccf9dab7fa5"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5275, 159, 111, 0, 67, "Subsubsection",ExpressionUUID->"79f17e88-9a24-4a25-96f7-84b51937eea7"],
Cell[5389, 161, 683, 19, 123, "Text",ExpressionUUID->"605b38c0-f382-4153-8eeb-559cbad52bc7"],
Cell[CellGroupData[{
Cell[6097, 184, 300, 7, 46, "Input",ExpressionUUID->"849e058e-8ac9-4da0-9644-72b2620dd375"],
Cell[6400, 193, 200, 4, 52, "Output",ExpressionUUID->"dc2da90c-2787-4103-9560-5d2ec62a0873"]
}, Open  ]],
Cell[6615, 200, 359, 10, 122, "Text",ExpressionUUID->"c78daf5a-6597-4b5a-97d0-265c34c908b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7011, 215, 100, 0, 67, "Subsubsection",ExpressionUUID->"671f5fdf-1931-41cd-b8d2-81d129847d8f"],
Cell[7114, 217, 255, 4, 122, "Text",ExpressionUUID->"01c2ba35-b61a-48e6-9e56-37098f220766"],
Cell[CellGroupData[{
Cell[7394, 225, 376, 10, 46, "Input",ExpressionUUID->"51907da9-de63-4684-8059-1ecab5db1e79"],
Cell[7773, 237, 318, 9, 55, "Output",ExpressionUUID->"296de9fe-b658-4862-8c6d-9fd177b05257"]
}, Open  ]],
Cell[8106, 249, 112, 0, 53, "Text",ExpressionUUID->"335bfe74-c74b-4b94-9aa3-b9e1f6492824"],
Cell[CellGroupData[{
Cell[8243, 253, 142, 2, 46, "Input",ExpressionUUID->"39df8ce5-486f-419c-b49d-2add46687883"],
Cell[8388, 257, 647, 20, 94, "Output",ExpressionUUID->"2bb9ac14-4723-4b90-86f8-f6c71f435529"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9084, 283, 85, 0, 67, "Subsubsection",ExpressionUUID->"18ffbdb6-293b-4b3b-a67a-8d359267b5a9"],
Cell[9172, 285, 678, 24, 191, "Text",ExpressionUUID->"85b70ca5-1558-40cd-b56f-9b119fbe96da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9887, 314, 111, 0, 67, "Subsubsection",ExpressionUUID->"c578828e-40ee-4062-b377-ac857cf9c762"],
Cell[10001, 316, 127, 0, 53, "Text",ExpressionUUID->"22bcb7fd-f7fa-4c37-a2e2-f85f1849915b"],
Cell[CellGroupData[{
Cell[10153, 320, 214, 4, 46, "Input",ExpressionUUID->"61c6fd16-125e-41f0-a38f-cf31549f39da"],
Cell[10370, 326, 343, 10, 70, "Output",ExpressionUUID->"eb3d1975-5e20-4a63-90f3-728088310645"]
}, Open  ]],
Cell[10728, 339, 127, 0, 53, "Text",ExpressionUUID->"92bd1fba-9dd4-4e79-ad6f-78a7eabf68d1"],
Cell[CellGroupData[{
Cell[10880, 343, 149, 2, 46, "Input",ExpressionUUID->"7586007f-337c-4ca3-80e5-fc23e41c9c06"],
Cell[11032, 347, 673, 21, 102, "Output",ExpressionUUID->"2111982f-dd76-4565-9236-a6b7f51ad19e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11754, 374, 114, 0, 67, "Subsubsection",ExpressionUUID->"e07962c2-3efd-4613-981c-bed62deb4171"],
Cell[11871, 376, 676, 21, 226, "Text",ExpressionUUID->"1bf55e2f-9648-4c26-8938-5f7f59f32cf4"],
Cell[12550, 399, 1876, 51, 295, "Input",ExpressionUUID->"760578ee-d4f8-4cfc-8d4e-c31909b1a3f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14463, 455, 113, 0, 67, "Subsubsection",ExpressionUUID->"cd73a828-5ec7-404d-bf5d-b2f23d1c7182"],
Cell[14579, 457, 379, 5, 191, "Text",ExpressionUUID->"e490e73f-92da-40a8-bcc8-0a4f626e75ff"],
Cell[14961, 464, 942, 27, 140, "Input",ExpressionUUID->"e5c0914c-1de7-4c39-ae8c-c13787145d72"],
Cell[CellGroupData[{
Cell[15928, 495, 442, 12, 109, "Input",ExpressionUUID->"10802c67-9ca6-490e-8a9d-7beed400ae29"],
Cell[16373, 509, 682, 19, 108, "Output",ExpressionUUID->"e85f5348-8260-42f9-8180-ffd57558283a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17104, 534, 115, 0, 67, "Subsubsection",ExpressionUUID->"78cba0f2-db6f-480d-bb7b-e6eab3ba8140"],
Cell[17222, 536, 1324, 36, 194, "Text",ExpressionUUID->"534b7e86-3484-4b31-8f90-1a8c408f26c3"],
Cell[18549, 574, 818, 23, 202, "Input",ExpressionUUID->"393f3dcb-cce1-4c2e-85f8-12b9895aeb2d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19404, 602, 114, 0, 67, "Subsubsection",ExpressionUUID->"e795eede-bfdd-4474-921f-85862e2308dd"],
Cell[19521, 604, 505, 13, 109, "Input",ExpressionUUID->"3fb5d668-260a-48ef-ab37-d10ef2a936be"],
Cell[CellGroupData[{
Cell[20051, 621, 241, 5, 46, "Input",ExpressionUUID->"f1666e5b-a6be-4088-ac19-58b6af6db608"],
Cell[20295, 628, 962, 28, 154, "Output",ExpressionUUID->"4d72d4e5-d4bf-4311-a134-3ae2dbcbfa5f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21306, 662, 95, 0, 67, "Subsubsection",ExpressionUUID->"443c5bca-c6d5-4ee6-91e6-d8181dd38872"],
Cell[21404, 664, 365, 9, 122, "Text",ExpressionUUID->"3e26d923-811b-49ef-9d7a-27d4abd6fde0"]
}, Open  ]]
}, Open  ]]
}
]
*)

