(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     46298,       1325]
NotebookOptionsPosition[     37425,       1175]
NotebookOutlinePosition[     38253,       1201]
CellTagsIndexPosition[     38210,       1198]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Curvature and the Einstein Equation", "Subtitle",ExpressionUUID->"681884af-d099-4c9c-be96-4b19990a64b0"],

Cell[TextData[{
 "This is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook ",
 StyleBox["Curvature and the Einstein Equation ",
  FontSlant->"Italic"],
 StyleBox["available from the book website.  F",
  FontVariations->{"CompatibilityType"->0}],
 "rom a given metric ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["g",
     FontSlant->"Italic"], "\[Alpha]\[Beta]"], TraditionalForm]],
  ExpressionUUID->"bb18fb7a-c22b-436a-902e-8025461c59c2"],
 " , it computes the components of the following: the inverse metric, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["g", "\[Lambda]\[Sigma]"], TraditionalForm]],ExpressionUUID->
  "54b7da73-1b6d-4061-a850-1e79143bd601"],
 ", the Christoffel symbols or affine connection,"
}], "Text",ExpressionUUID->"8eeec01f-c40f-45cf-b3b7-dd770d446c55"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Mu]\[Nu]"], "=", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{
      SuperscriptBox["g", "\[Lambda]\[Sigma]"], "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Mu]"], " ", 
        SubscriptBox["g", "\[Sigma]\[Nu]"]}], "+", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Nu]"], " ", 
        SubscriptBox["g", "\[Sigma]\[Mu]"]}], "-", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Sigma]"], " ", 
        SubscriptBox["g", "\[Mu]\[Nu]"]}]}], ")"}]}]}], TraditionalForm]],
  ExpressionUUID->"4e61c4eb-a9d9-4683-b79f-b56b17c25aba"],
 ","
}], "Text",ExpressionUUID->"aa593a8f-60e1-432e-89c8-99d19be7a3a8"],

Cell[TextData[{
 " ( ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[PartialD]", 
    RowBox[{"\[Alpha]", "  "}]], TraditionalForm]],ExpressionUUID->
  "b2c3892c-126c-463c-948c-73ecc2ba000d"],
 "stands for the partial derivative ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PartialD]", 
    RowBox[{"/", 
     RowBox[{"\[PartialD]", 
      SuperscriptBox["x", "\[Alpha]"]}]}]}], TraditionalForm]],ExpressionUUID->
  "a205dae9-31fd-4638-9dfb-b93044ac63c5"],
 "), the Riemann tensor,"
}], "Text",ExpressionUUID->"a01dbbf2-2b29-4d9b-be54-781019e685be"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox["R", "\[Lambda]"], "\[Mu]\[Nu]\[Sigma]"], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "\[Nu]"], " ", 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Mu]\[Sigma]"]}], 
     "-", 
     RowBox[{
      SubscriptBox["\[PartialD]", "\[Sigma]"], " ", 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Mu]\[Nu]"]}], "+", 
     RowBox[{
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Eta]"], "\[Mu]\[Sigma]"], 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Eta]\[Nu]"]}], "-", 
     
     RowBox[{
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Eta]"], "\[Mu]\[Nu]"], 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], 
       "\[Eta]\[Sigma]"]}]}]}], TraditionalForm]],ExpressionUUID->
  "38324b71-757b-440a-8b9c-d9a20fd9bc3d"],
 ","
}], "Text",ExpressionUUID->"681b7e12-835c-48a6-8eda-140dc2c57975"],

Cell["the Ricci tensor", "Text",ExpressionUUID->"81735623-702a-4c97-9fcd-76253c5a493b"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", "\[Mu]\[Nu]"], "=", 
    SubscriptBox[
     SuperscriptBox["R", "\[Lambda]"], "\[Mu]\[Lambda]\[Nu]"]}], 
   TraditionalForm]],ExpressionUUID->"b48a2733-dff1-4644-8900-c880525f71c1"],
 ","
}], "Text",ExpressionUUID->"b231510a-66fc-4af5-9a47-82da105a76f8"],

Cell["the scalar curvature,", "Text",ExpressionUUID->"6a551bb7-969c-452d-91e4-9eb4f5c5b8fd"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", 
    RowBox[{
     SuperscriptBox["g", "\[Mu]\[Nu]"], 
     SubscriptBox["R", "\[Mu]\[Nu]"]}]}], TraditionalForm]],ExpressionUUID->
  "57cc55a9-6b15-4d3e-98bd-b5e1c491cb2e"],
 ","
}], "Text",ExpressionUUID->"262dbed1-4f5f-46c3-8817-7e296e7f3a80"],

Cell["and the Einstein tensor,", "Text",ExpressionUUID->"d0d7b2c6-b050-44dd-a79d-ba54734c7fb6"],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["G", "\[Mu]\[Nu]"], "=", 
    RowBox[{
     SubscriptBox["R", "\[Mu]\[Nu]"], "-", 
     RowBox[{
      FractionBox["1", "2"], 
      SubscriptBox["g", "\[Mu]\[Nu]"], "R"}]}]}], TraditionalForm]],
  ExpressionUUID->"f21d08b0-5524-434d-a6ad-ea5deb8faf7a"],
 "."
}], "Text",ExpressionUUID->"d60636b9-8054-4868-a8de-414b28a12a3d"],

Cell[TextData[{
 "You must input the covariant components of the metric tensor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "f4a1b448-3e3a-4868-8ee3-6a8698dfda98"],
 " by editing the relevant input line in this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook. You may also wish to change the names of the coordinates. Only \
the nonzero components of the above quantities are displayed as the output. \
All the components computed are in the ",
 StyleBox["coordinate basis ",
  FontSlant->"Italic"],
 StyleBox["in which the metric was specified. ",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",ExpressionUUID->"1773f22f-cea2-4bc8-aa98-56b2d0c464fd"],

Cell[CellGroupData[{

Cell["Clearing the values of symbols:", "Subsubsection",ExpressionUUID->"9f5a6ef0-adf2-4fba-aeb4-021a354a5212"],

Cell["\<\
First clear any values that may already have been assigned to the names of \
the various objects to be calculated. The names of the coordinates that you \
will use are also cleared.\
\>", "Text",ExpressionUUID->"7d0e8339-e9f3-4f1d-9754-d6beeedd951f"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "coord", ",", " ", "metric", ",", "inversemetric", ",", " ", "affine", ",", 
   " ", "riemann", ",", " ", "ricci", ",", " ", "scalar", ",", " ", 
   "einstein", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "t"}], 
  "]"}]], "Input",ExpressionUUID->"3f23962c-e4ab-4904-9efe-f89b3aadcc36"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the dimension:", "Subsubsection",ExpressionUUID->"d5c45351-ca56-4ea7-b9ab-8d440f4ff021"],

Cell[TextData[{
 "The dimension ",
 StyleBox["n ",
  FontWeight->"Bold"],
 StyleBox["of the spacetime (or space) must be set:",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",ExpressionUUID->"da3c1d8f-3ceb-450d-b259-2e0536da70d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", "4"}]], "Input",ExpressionUUID->"db3a41b7-a756-4e63-ad81-90175bd0e2ab"],

Cell[BoxData["4"], "Output",ExpressionUUID->"5faa7ee6-f6e1-4ce5-befc-f6bbca9ae33a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining a list of coordinates:", "Subsubsection",ExpressionUUID->"d9841b60-61c3-41f3-a2c2-c8df0937af70"],

Cell["\<\
The example given here is the Schwarzschild metric. The coordinate choice of \
Schwarzschild is appropriate for this spherically symmetric spacetime. \
\>", "Text",ExpressionUUID->"357a1e0e-0226-48f4-aa2d-646cb6893c94"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"coord", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]", ",", "t"}], "}"}]}],
  FontWeight->"Bold"]], "Input",ExpressionUUID->"891d6a60-eeda-4738-9f99-\
5056205e18d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]", ",", "t"}], "}"}]], "Output",Ex\
pressionUUID->"10a2df87-1183-41cf-a8f8-f3630bf31e58"]
}, Open  ]],

Cell[TextData[{
 "You can change the names of the coordinates by simply editing the \
definition of ",
 StyleBox["coord",
  FontWeight->"Bold"],
 ", for example, to ",
 StyleBox["coord = {x, y, z, t}",
  FontWeight->"Bold"],
 ", when another set of coordinate names is more appropriate. In this program \
indices range over ",
 StyleBox["1 ",
  FontWeight->"Bold"],
 StyleBox["to ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["n.  ",
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Thus for spacetime they range from 1 to 4 and ",
  FontVariations->{"CompatibilityType"->0}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "4"], TraditionalForm]],ExpressionUUID->
  "0e3b897b-f0cf-4ab3-8583-3023c26cf22a"],
 " is the same as ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "0"], TraditionalForm]],ExpressionUUID->
  "e330fb6a-f9f0-4087-b6f9-e5965f06831e"],
 " used in the text. "
}], "Text",ExpressionUUID->"cf00d67d-f382-49ed-a196-51492a0bcdf6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining the metric:", "Subsubsection",ExpressionUUID->"7c1e4ef5-3a88-48f0-ad1c-941fc3d699f5"],

Cell["\<\
Input the metric as a list of lists, i.e., as a matrix. You can input the \
components of any metric here, but you must specify them as explicit \
functions of the coordinates.\
\>", "Text",ExpressionUUID->"60ced2c8-e6cb-4e11-ae01-d72d962d75d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", 
          RowBox[{"m", "/", "r"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]}], ",", "0", ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"r", "^", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{
       RowBox[{"r", "^", "2"}], " ", 
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "^", "2"}]}], ",", "0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", 
          RowBox[{"m", "/", "r"}]}]}], ")"}]}]}], "}"}]}], "}"}]}]], "Input",E\
xpressionUUID->"c69a98ec-7b6d-461e-8ca5-69fd4e23751a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", " ", "m"}], "r"]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SuperscriptBox["r", "2"], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", "0"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox[
       RowBox[{"2", " ", "m"}], "r"]}]}], "}"}]}], "}"}]], "Output",Expression\
UUID->"7a00453f-0e8d-4523-a445-4d931be13392"]
}, Open  ]],

Cell["You can also display this in matrix form.", "Text",ExpressionUUID->"7a087d8f-64d7-42c9-98ff-b4930521bcbb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "//", "MatrixForm"}]], "Input",ExpressionUUID->"3c9305aa-7730-46cb-a360-eaf25559a445"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["1", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"2", " ", "m"}], "r"]}]], "0", "0", "0"},
     {"0", 
      SuperscriptBox["r", "2"], "0", "0"},
     {"0", "0", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "0"},
     {"0", "0", "0", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox[
        RowBox[{"2", " ", "m"}], "r"]}]}
    }], "\[NoBreak]", ")"}],
  MatrixForm[#]& ]], "Output",ExpressionUUID->"1248def2-764e-4973-a0b8-\
36ce9834b602"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Note:", "Subsubsection",ExpressionUUID->"b1eec755-c696-460c-9424-ae5f0986b6a2"],

Cell[TextData[{
 "It is important not to use the symbols, ",
 StyleBox["i",
  FontWeight->"Bold"],
 ", ",
 StyleBox["j",
  FontWeight->"Bold"],
 ", ",
 StyleBox["k",
  FontWeight->"Bold"],
 ", ",
 StyleBox["l,",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["s, ",
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["or ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["n",
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" ",
  FontWeight->"Bold"],
 "as constants or coordinates in the metric that you specify above. The \
reason is that the first five of  those symbols are used as summation or \
table indices in the calculations done below, and ",
 StyleBox["n ",
  FontWeight->"Bold"],
 StyleBox["is the dimension of the space. ",
  FontVariations->{"CompatibilityType"->0}],
 "For example, if ",
 StyleBox["m",
  FontWeight->"Bold"],
 " were used as a summation or table index below, then you would get the \
wrong answer for the present metric because the ",
 StyleBox["m",
  FontWeight->"Bold"],
 " in the metric would be treated as an index, rather than as the mass."
}], "Text",ExpressionUUID->"a698725a-17ed-4ad0-84f6-426373867323"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the inverse metric:", "Subsubsection",ExpressionUUID->"8934d8f1-f052-426b-b4ec-d0d8c7cf6c47"],

Cell["The inverse metric is obtained through matrix inversion.", "Text",ExpressionUUID->"59eb44bf-5d9b-4eed-815e-a98c1a8dea84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inversemetric", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Inverse", "[", "metric", "]"}], "]"}]}]], "Input",ExpressionUUID->\
"79e36277-db93-4b1d-ac0c-feb037bfab03"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"2", " ", "m"}], "r"]}], ",", "0", ",", "0", ",", "0"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      SuperscriptBox["r", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], 
      SuperscriptBox["r", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox["r", 
      RowBox[{
       RowBox[{"2", " ", "m"}], "-", "r"}]]}], "}"}]}], "}"}]], "Output",Expre\
ssionUUID->"3cc6ee20-a91b-4898-9032-bb1e49065757"]
}, Open  ]],

Cell["This can also be displayed in matrix form:", "Text",ExpressionUUID->"15af27fd-d4ee-4d11-835b-a79ff7f2ecbf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inversemetric", "//", "MatrixForm"}]], "Input",ExpressionUUID->"9962c654-97bf-4e29-9d05-c656a41f482d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", " ", "m"}], "r"]}], "0", "0", "0"},
     {"0", 
      FractionBox["1", 
       SuperscriptBox["r", "2"]], "0", "0"},
     {"0", "0", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], 
       SuperscriptBox["r", "2"]], "0"},
     {"0", "0", "0", 
      FractionBox["r", 
       RowBox[{
        RowBox[{"2", " ", "m"}], "-", "r"}]]}
    }], "\[NoBreak]", ")"}],
  MatrixForm[#]& ]], "Output",ExpressionUUID->"3649addc-5763-444a-9621-\
3194d37f32f8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the Christoffel symbols:", "Subsubsection",ExpressionUUID->"d733be0e-5299-4456-a395-68caa9c8c047"],

Cell[TextData[{
 "The calculation of the components of the Christoffel symbols is done by \
transcribing the definition given earlier into the notation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions ",
 StyleBox["D",
  FontWeight->"Bold"],
 " for taking partial derivatives, ",
 StyleBox["Sum",
  FontWeight->"Bold"],
 " for summing over repeated indices, ",
 StyleBox["Table",
  FontWeight->"Bold"],
 " for forming a list of components, and ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " for simplifying the result."
}], "Text",ExpressionUUID->"e328a263-3fed-4246-b112-2585f3ce8bbc"],

Cell[BoxData[
 RowBox[{"affine", ":=", 
  RowBox[{"affine", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], "*", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"inversemetric", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "s"}], "]"}], "]"}], ")"}], "*", 
          "\[IndentingNewLine]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"s", ",", "j"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "k", "]"}], "]"}]}], " ", "]"}], "+", 
            "\[IndentingNewLine]", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"s", ",", "k"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "j", "]"}], "]"}]}], " ", "]"}], "-", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"j", ",", "k"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "s", "]"}], "]"}]}], " ", "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
    "]"}]}]}]], "Input",ExpressionUUID->"1933eba3-6cb2-4ac2-b613-\
8d086fe72e25"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying the Christoffel symbols:", "Subsubsection",ExpressionUUID->"540daf6d-7c28-42b2-9c23-34c19baaa952"],

Cell[TextData[{
 "The nonzero Christoffel symbols are displayed below. You need not follow \
the details of constructing the functions that we use for that purpose.  In \
the output the symbol \[CapitalGamma][1,2,3] stands for",
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["\[CapitalGamma]", "1"], "23"], TraditionalForm]],
  ExpressionUUID->"6914aea2-32ae-4314-9633-03ade786abc1"],
 ". Because the Christoffel symbols are symmetric under interchange of the \
last two indices, only the independent components are displayed."
}], "Text",ExpressionUUID->"7dfd5506-8676-413f-8fe3-d6ca4d4bfe3f"],

Cell[BoxData[
 RowBox[{"listaffine", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"affine", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", "0"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", 
        RowBox[{"affine", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    " ", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "j"}], "}"}]}], "]"}]}]], "Input",ExpressionU\
UID->"23b768c7-9e00-4cc6-a773-16c8e6d9454b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listaffine", "]"}], ",", "Null"}], "]"}], ",",
      "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",ExpressionUUID->\
"309788aa-043a-44c2-93df-056ae437b8e1"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\[CapitalGamma][1, 1, 1]\"\>", 
     FractionBox["m", 
      RowBox[{
       RowBox[{"2", " ", "m", " ", "r"}], "-", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"\[CapitalGamma][1, 2, 2]\"\>", 
     RowBox[{
      RowBox[{"2", " ", "m"}], "-", "r"}]},
    {"\<\"\[CapitalGamma][1, 3, 3]\"\>", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "m"}], "-", "r"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]},
    {"\<\"\[CapitalGamma][1, 4, 4]\"\>", 
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "m"}], "+", "r"}], ")"}]}], 
      SuperscriptBox["r", "3"]]},
    {"\<\"\[CapitalGamma][2, 2, 1]\"\>", 
     FractionBox["1", "r"]},
    {"\<\"\[CapitalGamma][2, 3, 3]\"\>", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
    {"\<\"\[CapitalGamma][3, 3, 1]\"\>", 
     FractionBox["1", "r"]},
    {"\<\"\[CapitalGamma][3, 3, 2]\"\>", 
     RowBox[{"Cot", "[", "\[Theta]", "]"}]},
    {"\<\"\[CapitalGamma][4, 4, 1]\"\>", 
     FractionBox["m", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "m", " ", "r"}], "+", 
       SuperscriptBox["r", "2"]}]]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[1.4]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  TableForm[#, TableSpacing -> {2, 2}]& ]], "Output",ExpressionUUID->\
"aa5c7568-71da-412a-b36b-17ab4fcd07a0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating and displaying the Riemann tensor:", "Subsubsection",ExpressionUUID->"72ed670d-3c2e-49f8-95bc-bbf5ade91a99"],

Cell[TextData[{
 "The components of the Riemann tensor, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["R", "\[Lambda]"], "\[Mu]\[Nu]\[Sigma]"], 
   TraditionalForm]],ExpressionUUID->"03745152-0e45-473e-ab8b-080a7dcb7e02"],
 ", are calculated using the definition given above."
}], "Text",ExpressionUUID->"0b111ee4-6fa3-4f3b-b868-7bbbaa1ec798"],

Cell[BoxData[
 RowBox[{"riemann", ":=", 
  RowBox[{"riemann", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"affine", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j", ",", "l"}], "]"}], "]"}], ",", 
         RowBox[{"coord", "[", 
          RowBox[{"[", "k", "]"}], "]"}]}], " ", "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"affine", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", 
         RowBox[{"coord", "[", 
          RowBox[{"[", "l", "]"}], "]"}]}], " ", "]"}], "+", 
       "\[IndentingNewLine]", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"affine", "[", 
            RowBox[{"[", 
             RowBox[{"s", ",", "j", ",", "l"}], "]"}], "]"}], " ", 
           RowBox[{"affine", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "k", ",", "s"}], "]"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"affine", "[", 
            RowBox[{"[", 
             RowBox[{"s", ",", "j", ",", "k"}], "]"}], "]"}], " ", 
           RowBox[{"affine", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "l", ",", "s"}], "]"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
    "]"}]}]}]], "Input",ExpressionUUID->"04040438-0887-4ff9-9dd9-\
acf5bd5cffd1"],

Cell[TextData[{
 "The nonzero components are displayed by the following functions. In the \
output, the symbol R[1, 2, 1, 3] stands for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["R", "1"], "213"], TraditionalForm]],ExpressionUUID->
  "0d2ca59f-2cfe-4ed8-b14c-293ae6413b71"],
 ", and similarly for the other components.",
 " You can obtain R[1, 2, 3, 1] from R[1, 2, 1, 3] using the antisymmetry of \
the Riemann tensor under exchange of the last two indices. The antisymmetry \
under exchange of the first two indices of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "\[Lambda]\[Mu]\[Nu]\[Sigma]"], TraditionalForm]],
  ExpressionUUID->"9e79ac93-0122-4660-b3e5-a4fefbf3c5e5"],
 " is not evident in the output because the components of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["R", "\[Lambda]"], "\[Mu]\[Nu]\[Sigma]"], 
   TraditionalForm]],ExpressionUUID->"3c8503c9-39fc-45f8-b5f2-f281d2f1cc3a"],
 " are displayed."
}], "Text",ExpressionUUID->"7fd57c7c-fa20-46bf-a4bb-9283920ccf59"],

Cell[BoxData[
 RowBox[{"listriemann", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"riemann", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "]"}], "]"}], ",", 
        "0"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"R", "[", 
          RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "]"}], "]"}], ",", 
        RowBox[{"riemann", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "]"}], "]"}]}], 
       "}"}]}], "]"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", 
      RowBox[{"k", "-", "1"}]}], "}"}]}], "]"}]}]], "Input",ExpressionUUID->\
"b1724c06-8c46-411d-8dd2-d17ceb8ad1c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listriemann", "]"}], ",", "Null"}], "]"}], 
     ",", "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",ExpressionUUID->\
"d4880e4f-542c-4748-92a2-51fbfeda707e"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"R[1, 2, 2, 1]\"\>", 
     FractionBox["m", "r"]},
    {"\<\"R[1, 3, 3, 1]\"\>", 
     FractionBox[
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "r"]},
    {"\<\"R[1, 4, 4, 1]\"\>", 
     FractionBox[
      RowBox[{"2", " ", "m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "m"}], "+", "r"}], ")"}]}], 
      SuperscriptBox["r", "4"]]},
    {"\<\"R[2, 1, 2, 1]\"\>", 
     FractionBox["m", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "m"}], "-", "r"}], ")"}], " ", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[2, 3, 3, 2]\"\>", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "r"]}]},
    {"\<\"R[2, 4, 4, 2]\"\>", 
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "m"}], "-", "r"}], ")"}]}], 
      SuperscriptBox["r", "4"]]},
    {"\<\"R[3, 1, 3, 1]\"\>", 
     FractionBox["m", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "m"}], "-", "r"}], ")"}], " ", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[3, 2, 3, 2]\"\>", 
     FractionBox[
      RowBox[{"2", " ", "m"}], "r"]},
    {"\<\"R[3, 4, 4, 3]\"\>", 
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "m"}], "-", "r"}], ")"}]}], 
      SuperscriptBox["r", "4"]]},
    {"\<\"R[4, 1, 4, 1]\"\>", 
     FractionBox[
      RowBox[{"2", " ", "m"}], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "m"}], "+", "r"}], ")"}]}]]},
    {"\<\"R[4, 2, 4, 2]\"\>", 
     RowBox[{"-", 
      FractionBox["m", "r"]}]},
    {"\<\"R[4, 3, 4, 3]\"\>", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "r"]}]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[1.4]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  TableForm[#, TableSpacing -> {2, 2}]& ]], "Output",ExpressionUUID->\
"284ae1ba-6402-405e-ac22-050160e433cc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating and displaying the Ricci tensor:", "Subsubsection",ExpressionUUID->"74296700-2c55-49bd-a362-50c30489f58f"],

Cell[TextData[{
 "The Ricci tensor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "7c8b7702-663a-439a-83e5-1c6001d4064c"],
 " was defined by summing the first and third indices of the Riemann tensor \
(which has the first index already raised)."
}], "Text",ExpressionUUID->"6348dc89-66a7-42cf-8cc8-ec2caf1b28e6"],

Cell[BoxData[
 RowBox[{"ricci", ":=", 
  RowBox[{"ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"riemann", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "i", ",", "l"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
    "]"}]}]}]], "Input",ExpressionUUID->"6163b8c9-9cab-41c2-9a66-\
c2b2ceb8c069"],

Cell[TextData[{
 "Next we display the nonzero components. In the output, R[1, 2] denotes ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "12"], TraditionalForm]],ExpressionUUID->
  "61c07a70-213e-4726-8b10-21c512747e9f"],
 ", and similarly for the other components."
}], "Text",ExpressionUUID->"dcb001bc-75b0-40d9-803c-85dd2a3b9803"],

Cell[BoxData[
 RowBox[{"listricci", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"ricci", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}], ",", "0"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"R", "[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}], ",", 
        RowBox[{"ricci", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}]}], "}"}]}], "]"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", "j"}], "}"}]}], "]"}]}]], "Input",ExpressionU\
UID->"0c83cd0a-3a1f-4e83-993b-cea7400f44c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listricci", "]"}], ",", "Null"}], "]"}], ",", 
     "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",ExpressionUUID->\
"70b66abd-ee79-45ca-9618-a7965c04a91c"],

Cell[BoxData[
 InterpretationBox[
  InterpretationBox["\<\"\"\>",
   {}],
  TableForm[{}, TableSpacing -> {2, 2}]]], "Output",ExpressionUUID->"c8fdf3a2-\
47b3-4de3-a201-631bb59864e1"]
}, Open  ]],

Cell["\<\
A vanishing table (as with the Schwarzschild metric example)  means that the \
vacuum Einstein equation is satisfied.\
\>", "Text",ExpressionUUID->"2b596fb8-febb-4155-8164-a922243a64ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the scalar curvature:", "Subsubsection",ExpressionUUID->"49263813-204d-42de-aa99-fdead3f054d5"],

Cell[TextData[{
 "The scalar curvature ",
 StyleBox["R",
  FontSlant->"Italic"],
 " is calculated using the inverse metric and the Ricci tensor. The result is \
displayed in the output line."
}], "Text",ExpressionUUID->"fa60f508-1a5c-4989-a8aa-94d7fb691d88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"scalar", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"inversemetric", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], 
      RowBox[{"ricci", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
   "]"}]}]], "Input",ExpressionUUID->"90c8dcd4-1062-46e2-b2e6-af4ba233c4b5"],

Cell[BoxData["0"], "Output",ExpressionUUID->"5a6d7661-d5c0-46b2-ae68-154b1037579a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the Einstein tensor:", "Subsubsection",ExpressionUUID->"88007471-e14b-4b71-b0e0-bab06112b529"],

Cell[TextData[{
 "The Einstein tensor,  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["G", "\[Mu]\[Nu]"], "=", 
    RowBox[{
     SubscriptBox["R", "\[Mu]\[Nu]"], "-", 
     RowBox[{
      FractionBox["1", "2"], 
      SubscriptBox["g", "\[Mu]\[Nu]"], "R"}]}]}], TraditionalForm]],
  ExpressionUUID->"7de18f8f-5975-4ba6-a0ac-475b9637622f"],
 ", is found from the tensors already calculated."
}], "Text",ExpressionUUID->"5138128e-8f42-4418-a07d-1276ccec0a69"],

Cell[BoxData[
 RowBox[{"einstein", ":=", 
  RowBox[{"einstein", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ricci", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], "scalar", "*", "metric"}]}], 
    "]"}]}]}]], "Input",ExpressionUUID->"3d3d0c2b-fab2-4f92-9684-\
ef2e39e1acb8"],

Cell["\<\
The results are displayed in the same way as for the Ricci tensor earlier.\
\>", "Text",ExpressionUUID->"bc47ccb5-ce62-4a18-9443-695bfd2f153a"],

Cell[BoxData[
 RowBox[{"listeinstein", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"einstein", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}], ",", "0"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"G", "[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}], ",", 
        RowBox[{"einstein", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}]}], "}"}]}], "]"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", "j"}], "}"}]}], "]"}]}]], "Input",ExpressionU\
UID->"d7c81f69-d922-4c4e-a121-7e1465f2eac0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listeinstein", "]"}], ",", "Null"}], "]"}], 
     ",", "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",ExpressionUUID->\
"958bf98e-c662-4163-8482-429bafa00b21"],

Cell[BoxData[
 InterpretationBox[
  InterpretationBox["\<\"\"\>",
   {}],
  TableForm[{}, TableSpacing -> {2, 2}]]], "Output",ExpressionUUID->"fb2c0574-\
2b37-427f-a5d5-abacf1689ba9"]
}, Open  ]],

Cell["\<\
A vanishing table means that the vacuum Einstein equation is satisfied!\
\>", "Text",ExpressionUUID->"425785f2-4e86-4a18-9022-e626b23df6b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Acknowledgment", "Subsubsection",ExpressionUUID->"4c0a0c52-b041-47da-bceb-4f0061cf4878"],

Cell[TextData[{
 "This program was kindly written by ",
 StyleBox["Leonard Parker, University of Wisconsin, Milwaukee ",
  FontSlant->"Italic"],
 StyleBox["especially ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["for this text. ",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",ExpressionUUID->"de2a8ae7-a1a5-43ac-aea2-c56de7d482c4"]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{770, 616},
WindowMargins->{{257, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792},
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "home", "hartle", 
   "131book", "math", "Curvature"}, "curvature-n.ps1", CharacterEncoding -> 
  "ISO8859-1"]},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d982bbef-e9da-4414-bc16-9d2b11e2a1b2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 110, 0, 79, "Subtitle",ExpressionUUID->"681884af-d099-4c9c-be96-4b19990a64b0"],
Cell[693, 24, 814, 22, 160, "Text",ExpressionUUID->"8eeec01f-c40f-45cf-b3b7-dd770d446c55"],
Cell[1510, 48, 787, 22, 59, "Text",ExpressionUUID->"aa593a8f-60e1-432e-89c8-99d19be7a3a8"],
Cell[2300, 72, 547, 16, 54, "Text",ExpressionUUID->"a01dbbf2-2b29-4d9b-be54-781019e685be"],
Cell[2850, 90, 1058, 30, 55, "Text",ExpressionUUID->"681b7e12-835c-48a6-8eda-140dc2c57975"],
Cell[3911, 122, 87, 0, 53, "Text",ExpressionUUID->"81735623-702a-4c97-9fcd-76253c5a493b"],
Cell[4001, 124, 330, 9, 55, "Text",ExpressionUUID->"b231510a-66fc-4af5-9a47-82da105a76f8"],
Cell[4334, 135, 92, 0, 53, "Text",ExpressionUUID->"6a551bb7-969c-452d-91e4-9eb4f5c5b8fd"],
Cell[4429, 137, 309, 9, 55, "Text",ExpressionUUID->"262dbed1-4f5f-46c3-8817-7e296e7f3a80"],
Cell[4741, 148, 95, 0, 53, "Text",ExpressionUUID->"d0d7b2c6-b050-44dd-a79d-ba54734c7fb6"],
Cell[4839, 150, 403, 13, 59, "Text",ExpressionUUID->"d60636b9-8054-4868-a8de-414b28a12a3d"],
Cell[5245, 165, 732, 16, 228, "Text",ExpressionUUID->"1773f22f-cea2-4bc8-aa98-56b2d0c464fd"],
Cell[CellGroupData[{
Cell[6002, 185, 111, 0, 67, "Subsubsection",ExpressionUUID->"9f5a6ef0-adf2-4fba-aeb4-021a354a5212"],
Cell[6116, 187, 260, 4, 122, "Text",ExpressionUUID->"7d0e8339-e9f3-4f1d-9754-d6beeedd951f"],
Cell[6379, 193, 340, 6, 78, "Input",ExpressionUUID->"3f23962c-e4ab-4904-9efe-f89b3aadcc36"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6756, 204, 102, 0, 67, "Subsubsection",ExpressionUUID->"d5c45351-ca56-4ea7-b9ab-8d440f4ff021"],
Cell[6861, 206, 238, 6, 53, "Text",ExpressionUUID->"da3c1d8f-3ceb-450d-b259-2e0536da70d1"],
Cell[CellGroupData[{
Cell[7124, 216, 104, 1, 46, "Input",ExpressionUUID->"db3a41b7-a756-4e63-ad81-90175bd0e2ab"],
Cell[7231, 219, 83, 0, 52, "Output",ExpressionUUID->"5faa7ee6-f6e1-4ce5-befc-f6bbca9ae33a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7363, 225, 111, 0, 67, "Subsubsection",ExpressionUUID->"d9841b60-61c3-41f3-a2c2-c8df0937af70"],
Cell[7477, 227, 229, 3, 122, "Text",ExpressionUUID->"357a1e0e-0226-48f4-aa2d-646cb6893c94"],
Cell[CellGroupData[{
Cell[7731, 234, 236, 6, 46, "Input",ExpressionUUID->"891d6a60-eeda-4738-9f99-5056205e18d8"],
Cell[7970, 242, 162, 3, 52, "Output",ExpressionUUID->"10a2df87-1183-41cf-a8f8-f3630bf31e58"]
}, Open  ]],
Cell[8147, 248, 994, 29, 192, "Text",ExpressionUUID->"cf00d67d-f382-49ed-a196-51492a0bcdf6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9178, 282, 100, 0, 60, "Subsubsection",ExpressionUUID->"7c1e4ef5-3a88-48f0-ad1c-941fc3d699f5"],
Cell[9281, 284, 255, 4, 71, "Text",ExpressionUUID->"60ced2c8-e6cb-4e11-ae01-d72d962d75d5"],
Cell[CellGroupData[{
Cell[9561, 292, 963, 31, 62, "Input",ExpressionUUID->"c69a98ec-7b6d-461e-8ca5-69fd4e23751a"],
Cell[10527, 325, 793, 26, 126, "Output",ExpressionUUID->"7a00453f-0e8d-4523-a445-4d931be13392"]
}, Open  ]],
Cell[11335, 354, 112, 0, 46, "Text",ExpressionUUID->"7a087d8f-64d7-42c9-98ff-b4930521bcbb"],
Cell[CellGroupData[{
Cell[11472, 358, 119, 1, 39, "Input",ExpressionUUID->"3c9305aa-7730-46cb-a360-eaf25559a445"],
Cell[11594, 361, 656, 22, 177, "Output",ExpressionUUID->"1248def2-764e-4973-a0b8-36ce9834b602"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12299, 389, 85, 0, 60, "Subsubsection",ExpressionUUID->"b1eec755-c696-460c-9424-ae5f0986b6a2"],
Cell[12387, 391, 1254, 40, 171, "Text",ExpressionUUID->"a698725a-17ed-4ad0-84f6-426373867323"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13678, 436, 111, 0, 60, "Subsubsection",ExpressionUUID->"8934d8f1-f052-426b-b4ec-d0d8c7cf6c47"],
Cell[13792, 438, 127, 0, 46, "Text",ExpressionUUID->"59eb44bf-5d9b-4eed-815e-a98c1a8dea84"],
Cell[CellGroupData[{
Cell[13944, 442, 193, 4, 39, "Input",ExpressionUUID->"79e36277-db93-4b1d-ac0c-feb037bfab03"],
Cell[14140, 448, 762, 24, 115, "Output",ExpressionUUID->"3cc6ee20-a91b-4898-9032-bb1e49065757"]
}, Open  ]],
Cell[14917, 475, 113, 0, 46, "Text",ExpressionUUID->"15af27fd-d4ee-4d11-835b-a79ff7f2ecbf"],
Cell[CellGroupData[{
Cell[15055, 479, 126, 1, 39, "Input",ExpressionUUID->"9962c654-97bf-4e29-9d05-c656a41f482d"],
Cell[15184, 482, 629, 21, 187, "Output",ExpressionUUID->"3649addc-5763-444a-9621-3194d37f32f8"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15862, 509, 116, 0, 60, "Subsubsection",ExpressionUUID->"d733be0e-5299-4456-a395-68caa9c8c047"],
Cell[15981, 511, 678, 21, 121, "Text",ExpressionUUID->"e328a263-3fed-4246-b112-2585f3ce8bbc"],
Cell[16662, 534, 1855, 51, 223, "Input",ExpressionUUID->"1933eba3-6cb2-4ac2-b613-8d086fe72e25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18554, 590, 115, 0, 60, "Subsubsection",ExpressionUUID->"540daf6d-7c28-42b2-9c23-34c19baaa952"],
Cell[18672, 592, 649, 13, 121, "Text",ExpressionUUID->"7dfd5506-8676-413f-8fe3-d6ca4d4bfe3f"],
Cell[19324, 607, 921, 27, 108, "Input",ExpressionUUID->"23b768c7-9e00-4cc6-a773-16c8e6d9454b"],
Cell[CellGroupData[{
Cell[20270, 638, 421, 12, 85, "Input",ExpressionUUID->"309788aa-043a-44c2-93df-056ae437b8e1"],
Cell[20694, 652, 1760, 52, 383, "Output",ExpressionUUID->"aa5c7568-71da-412a-b36b-17ab4fcd07a0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22503, 710, 126, 0, 60, "Subsubsection",ExpressionUUID->"72ed670d-3c2e-49f8-95bc-bbf5ade91a99"],
Cell[22632, 712, 362, 8, 71, "Text",ExpressionUUID->"0b111ee4-6fa3-4f3b-b868-7bbbaa1ec798"],
Cell[22997, 722, 1895, 52, 177, "Input",ExpressionUUID->"04040438-0887-4ff9-9dd9-acf5bd5cffd1"],
Cell[24895, 776, 1033, 23, 146, "Text",ExpressionUUID->"7fd57c7c-fa20-46bf-a4bb-9283920ccf59"],
Cell[25931, 801, 1043, 30, 108, "Input",ExpressionUUID->"b1724c06-8c46-411d-8dd2-d17ceb8ad1c8"],
Cell[CellGroupData[{
Cell[26999, 835, 422, 12, 85, "Input",ExpressionUUID->"d4880e4f-542c-4748-92a2-51fbfeda707e"],
Cell[27424, 849, 2503, 82, 595, "Output",ExpressionUUID->"284ae1ba-6402-405e-ac22-050160e433cc"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29976, 937, 124, 0, 60, "Subsubsection",ExpressionUUID->"74296700-2c55-49bd-a362-50c30489f58f"],
Cell[30103, 939, 367, 8, 71, "Text",ExpressionUUID->"6348dc89-66a7-42cf-8cc8-ec2caf1b28e6"],
Cell[30473, 949, 636, 18, 108, "Input",ExpressionUUID->"6163b8c9-9cab-41c2-9a66-c2b2ceb8c069"],
Cell[31112, 969, 335, 7, 71, "Text",ExpressionUUID->"dcb001bc-75b0-40d9-803c-85dd2a3b9803"],
Cell[31450, 978, 791, 23, 85, "Input",ExpressionUUID->"0c83cd0a-3a1f-4e83-993b-cea7400f44c0"],
Cell[CellGroupData[{
Cell[32266, 1005, 420, 12, 85, "Input",ExpressionUUID->"70b66abd-ee79-45ca-9618-a7965c04a91c"],
Cell[32689, 1019, 183, 5, 58, "Output",ExpressionUUID->"c8fdf3a2-47b3-4de3-a201-631bb59864e1"]
}, Open  ]],
Cell[32887, 1027, 196, 3, 71, "Text",ExpressionUUID->"2b596fb8-febb-4155-8164-a922243a64ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33120, 1035, 113, 0, 60, "Subsubsection",ExpressionUUID->"49263813-204d-42de-aa99-fdead3f054d5"],
Cell[33236, 1037, 258, 6, 71, "Text",ExpressionUUID->"fa60f508-1a5c-4989-a8aa-94d7fb691d88"],
Cell[CellGroupData[{
Cell[33519, 1047, 560, 16, 85, "Input",ExpressionUUID->"90c8dcd4-1062-46e2-b2e6-af4ba233c4b5"],
Cell[34082, 1065, 83, 0, 39, "Output",ExpressionUUID->"5a6d7661-d5c0-46b2-ae68-154b1037579a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34214, 1071, 112, 0, 60, "Subsubsection",ExpressionUUID->"88007471-e14b-4b71-b0e0-bab06112b529"],
Cell[34329, 1073, 470, 13, 52, "Text",ExpressionUUID->"5138128e-8f42-4418-a07d-1276ccec0a69"],
Cell[34802, 1088, 310, 9, 39, "Input",ExpressionUUID->"3d3d0c2b-fab2-4f92-9684-ef2e39e1acb8"],
Cell[35115, 1099, 153, 2, 46, "Text",ExpressionUUID->"bc47ccb5-ce62-4a18-9443-695bfd2f153a"],
Cell[35271, 1103, 800, 23, 108, "Input",ExpressionUUID->"d7c81f69-d922-4c4e-a121-7e1465f2eac0"],
Cell[CellGroupData[{
Cell[36096, 1130, 423, 12, 85, "Input",ExpressionUUID->"958bf98e-c662-4163-8482-429bafa00b21"],
Cell[36522, 1144, 183, 5, 58, "Output",ExpressionUUID->"fb2c0574-2b37-427f-a5d5-abacf1689ba9"]
}, Open  ]],
Cell[36720, 1152, 150, 2, 46, "Text",ExpressionUUID->"425785f2-4e86-4a18-9022-e626b23df6b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36907, 1159, 94, 0, 60, "Subsubsection",ExpressionUUID->"4c0a0c52-b041-47da-bceb-4f0061cf4878"],
Cell[37004, 1161, 393, 10, 71, "Text",ExpressionUUID->"de2a8ae7-a1a5-43ac-aea2-c56de7d482c4"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

