(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     94856,       2742]
NotebookOptionsPosition[     82823,       2538]
NotebookOutlinePosition[     83651,       2564]
CellTagsIndexPosition[     83608,       2561]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Curvature and the Einstein Equation", "Subtitle",ExpressionUUID->"681884af-d099-4c9c-be96-4b19990a64b0"],

Cell[TextData[{
 "This is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook ",
 StyleBox["Curvature and the Einstein Equation ",
  FontSlant->"Italic"],
 StyleBox["available from the book website.  F",
  FontVariations->{"CompatibilityType"->0}],
 "rom a given metric ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["g",
     FontSlant->"Italic"], "\[Alpha]\[Beta]"], TraditionalForm]],
  ExpressionUUID->"bb18fb7a-c22b-436a-902e-8025461c59c2"],
 " , it computes the components of the following: the inverse metric, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["g", "\[Lambda]\[Sigma]"], TraditionalForm]],ExpressionUUID->
  "54b7da73-1b6d-4061-a850-1e79143bd601"],
 ", the Christoffel symbols or affine connection,"
}], "Text",ExpressionUUID->"8eeec01f-c40f-45cf-b3b7-dd770d446c55"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Mu]\[Nu]"], "=", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{
      SuperscriptBox["g", "\[Lambda]\[Sigma]"], "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Mu]"], " ", 
        SubscriptBox["g", "\[Sigma]\[Nu]"]}], "+", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Nu]"], " ", 
        SubscriptBox["g", "\[Sigma]\[Mu]"]}], "-", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Sigma]"], " ", 
        SubscriptBox["g", "\[Mu]\[Nu]"]}]}], ")"}]}]}], TraditionalForm]],
  ExpressionUUID->"4e61c4eb-a9d9-4683-b79f-b56b17c25aba"],
 ","
}], "Text",ExpressionUUID->"aa593a8f-60e1-432e-89c8-99d19be7a3a8"],

Cell[TextData[{
 " ( ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[PartialD]", 
    RowBox[{"\[Alpha]", "  "}]], TraditionalForm]],ExpressionUUID->
  "b2c3892c-126c-463c-948c-73ecc2ba000d"],
 "stands for the partial derivative ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PartialD]", 
    RowBox[{"/", 
     RowBox[{"\[PartialD]", 
      SuperscriptBox["x", "\[Alpha]"]}]}]}], TraditionalForm]],ExpressionUUID->
  "a205dae9-31fd-4638-9dfb-b93044ac63c5"],
 "), the Riemann tensor,"
}], "Text",ExpressionUUID->"a01dbbf2-2b29-4d9b-be54-781019e685be"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox["R", "\[Lambda]"], "\[Mu]\[Nu]\[Sigma]"], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "\[Nu]"], " ", 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Mu]\[Sigma]"]}], 
     "-", 
     RowBox[{
      SubscriptBox["\[PartialD]", "\[Sigma]"], " ", 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Mu]\[Nu]"]}], "+", 
     RowBox[{
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Eta]"], "\[Mu]\[Sigma]"], 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], "\[Eta]\[Nu]"]}], "-", 
     
     RowBox[{
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Eta]"], "\[Mu]\[Nu]"], 
      SubscriptBox[
       SuperscriptBox["\[CapitalGamma]", "\[Lambda]"], 
       "\[Eta]\[Sigma]"]}]}]}], TraditionalForm]],ExpressionUUID->
  "38324b71-757b-440a-8b9c-d9a20fd9bc3d"],
 ","
}], "Text",ExpressionUUID->"681b7e12-835c-48a6-8eda-140dc2c57975"],

Cell["the Ricci tensor", "Text",ExpressionUUID->"81735623-702a-4c97-9fcd-76253c5a493b"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["R", "\[Mu]\[Nu]"], "=", 
    SubscriptBox[
     SuperscriptBox["R", "\[Lambda]"], "\[Mu]\[Lambda]\[Nu]"]}], 
   TraditionalForm]],ExpressionUUID->"b48a2733-dff1-4644-8900-c880525f71c1"],
 ","
}], "Text",ExpressionUUID->"b231510a-66fc-4af5-9a47-82da105a76f8"],

Cell["the scalar curvature,", "Text",ExpressionUUID->"6a551bb7-969c-452d-91e4-9eb4f5c5b8fd"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", 
    RowBox[{
     SuperscriptBox["g", "\[Mu]\[Nu]"], 
     SubscriptBox["R", "\[Mu]\[Nu]"]}]}], TraditionalForm]],ExpressionUUID->
  "57cc55a9-6b15-4d3e-98bd-b5e1c491cb2e"],
 ","
}], "Text",ExpressionUUID->"262dbed1-4f5f-46c3-8817-7e296e7f3a80"],

Cell["and the Einstein tensor,", "Text",ExpressionUUID->"d0d7b2c6-b050-44dd-a79d-ba54734c7fb6"],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["G", "\[Mu]\[Nu]"], "=", 
    RowBox[{
     SubscriptBox["R", "\[Mu]\[Nu]"], "-", 
     RowBox[{
      FractionBox["1", "2"], 
      SubscriptBox["g", "\[Mu]\[Nu]"], "R"}]}]}], TraditionalForm]],
  ExpressionUUID->"f21d08b0-5524-434d-a6ad-ea5deb8faf7a"],
 "."
}], "Text",ExpressionUUID->"d60636b9-8054-4868-a8de-414b28a12a3d"],

Cell[TextData[{
 "You must input the covariant components of the metric tensor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "f4a1b448-3e3a-4868-8ee3-6a8698dfda98"],
 " by editing the relevant input line in this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook. You may also wish to change the names of the coordinates. Only \
the nonzero components of the above quantities are displayed as the output. \
All the components computed are in the ",
 StyleBox["coordinate basis ",
  FontSlant->"Italic"],
 StyleBox["in which the metric was specified. ",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",ExpressionUUID->"1773f22f-cea2-4bc8-aa98-56b2d0c464fd"],

Cell[CellGroupData[{

Cell["Clearing the values of symbols:", "Subsubsection",ExpressionUUID->"9f5a6ef0-adf2-4fba-aeb4-021a354a5212"],

Cell["\<\
First clear any values that may already have been assigned to the names of \
the various objects to be calculated. The names of the coordinates that you \
will use are also cleared.\
\>", "Text",ExpressionUUID->"7d0e8339-e9f3-4f1d-9754-d6beeedd951f"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "coord", ",", " ", "metric", ",", "inversemetric", ",", " ", "affine", ",", 
   " ", "riemann", ",", " ", "ricci", ",", " ", "scalar", ",", " ", 
   "einstein", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.815222450809309*^9, 3.815222480654057*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"3f23962c-e4ab-4904-9efe-f89b3aadcc36"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the dimension:", "Subsubsection",ExpressionUUID->"d5c45351-ca56-4ea7-b9ab-8d440f4ff021"],

Cell[TextData[{
 "The dimension ",
 StyleBox["n ",
  FontWeight->"Bold"],
 StyleBox["of the spacetime (or space) must be set:",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",ExpressionUUID->"da3c1d8f-3ceb-450d-b259-2e0536da70d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", "4"}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"db3a41b7-a756-4e63-ad81-90175bd0e2ab"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.815222671472495*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"5e051290-32c7-4d48-85dd-dda3457f7135"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining a list of coordinates:", "Subsubsection",ExpressionUUID->"d9841b60-61c3-41f3-a2c2-c8df0937af70"],

Cell["\<\
The example given here is the Schwarzschild metric. The coordinate choice of \
Schwarzschild is appropriate for this spherically symmetric spacetime. \
\>", "Text",ExpressionUUID->"357a1e0e-0226-48f4-aa2d-646cb6893c94"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"coord", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]", ",", "t"}], "}"}]}],
  FontWeight->"Bold"]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"891d6a60-eeda-4738-9f99-5056205e18d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]", ",", "t"}], "}"}]], "Output",
 CellChangeTimes->{3.815222693568372*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"9117a4d4-5d0d-47e9-9e7d-7bb5da9872bc"]
}, Open  ]],

Cell[TextData[{
 "You can change the names of the coordinates by simply editing the \
definition of ",
 StyleBox["coord",
  FontWeight->"Bold"],
 ", for example, to ",
 StyleBox["coord = {x, y, z, t}",
  FontWeight->"Bold"],
 ", when another set of coordinate names is more appropriate. In this program \
indices range over ",
 StyleBox["1 ",
  FontWeight->"Bold"],
 StyleBox["to ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["n.  ",
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Thus for spacetime they range from 1 to 4 and ",
  FontVariations->{"CompatibilityType"->0}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "4"], TraditionalForm]],ExpressionUUID->
  "0e3b897b-f0cf-4ab3-8583-3023c26cf22a"],
 " is the same as ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "0"], TraditionalForm]],ExpressionUUID->
  "e330fb6a-f9f0-4087-b6f9-e5965f06831e"],
 " used in the text. "
}], "Text",ExpressionUUID->"cf00d67d-f382-49ed-a196-51492a0bcdf6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining the metric:", "Subsubsection",ExpressionUUID->"7c1e4ef5-3a88-48f0-ad1c-941fc3d699f5"],

Cell["\<\
Input the metric as a list of lists, i.e., as a matrix. You can input the \
components of any metric here, but you must specify them as explicit \
functions of the coordinates.\
\>", "Text",ExpressionUUID->"60ced2c8-e6cb-4e11-ae01-d72d962d75d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"R", "[", "t", "]"}], ")"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"k", "*", 
          RowBox[{"r", "^", "2"}]}]}], ")"}]}], ",", "0", ",", "0", ",", 
      "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"R", "[", "t", "]"}], ")"}], "^", "2"}], ")"}], "*", 
       RowBox[{"r", "^", "2"}]}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"R", "[", "t", "]"}], ")"}], "^", "2"}], ")"}], "*", 
       RowBox[{"r", "^", "2"}], " ", 
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "^", "2"}]}], ",", "0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "1"}]}], " ", "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.815222847384941*^9, 3.815222901678317*^9}, 
   3.815223376610301*^9, {3.81522348736901*^9, 3.815223543775815*^9}, {
   3.8152235786627073`*^9, 3.815223623942843*^9}, {3.815224122637697*^9, 
   3.8152241660271587`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"c69a98ec-7b6d-461e-8ca5-69fd4e23751a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"], 
      RowBox[{"1", "-", 
       RowBox[{"k", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", "0"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.815223631544868*^9, 3.8152241740588713`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"3489848f-2a38-4c07-8474-632c2155c402"]
}, Open  ]],

Cell["You can also display this in matrix form.", "Text",ExpressionUUID->"7a087d8f-64d7-42c9-98ff-b4930521bcbb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"3c9305aa-7730-46cb-a360-eaf25559a445"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"], 
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox["r", "2"]}]}]], "0", "0", "0"},
     {"0", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"]}], "0", "0"},
     {"0", "0", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "0"},
     {"0", "0", "0", 
      RowBox[{"-", "1"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.81522418982822*^9},
 CellLabel->
  "Out[6]//MatrixForm=",ExpressionUUID->"0cc1961b-9c2a-45ce-9ac9-\
04a56fa65bf0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Note:", "Subsubsection",ExpressionUUID->"b1eec755-c696-460c-9424-ae5f0986b6a2"],

Cell[TextData[{
 "It is important not to use the symbols, ",
 StyleBox["i",
  FontWeight->"Bold"],
 ", ",
 StyleBox["j",
  FontWeight->"Bold"],
 ", ",
 StyleBox["k",
  FontWeight->"Bold"],
 ", ",
 StyleBox["l,",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["s, ",
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["or ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["n",
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" ",
  FontWeight->"Bold"],
 "as constants or coordinates in the metric that you specify above. The \
reason is that the first five of  those symbols are used as summation or \
table indices in the calculations done below, and ",
 StyleBox["n ",
  FontWeight->"Bold"],
 StyleBox["is the dimension of the space. ",
  FontVariations->{"CompatibilityType"->0}],
 "For example, if ",
 StyleBox["m",
  FontWeight->"Bold"],
 " were used as a summation or table index below, then you would get the \
wrong answer for the present metric because the ",
 StyleBox["m",
  FontWeight->"Bold"],
 " in the metric would be treated as an index, rather than as the mass."
}], "Text",ExpressionUUID->"a698725a-17ed-4ad0-84f6-426373867323"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the inverse metric:", "Subsubsection",ExpressionUUID->"8934d8f1-f052-426b-b4ec-d0d8c7cf6c47"],

Cell["The inverse metric is obtained through matrix inversion.", "Text",ExpressionUUID->"59eb44bf-5d9b-4eed-815e-a98c1a8dea84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inversemetric", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Inverse", "[", "metric", "]"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"79e36277-db93-4b1d-ac0c-feb037bfab03"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"k", " ", 
        SuperscriptBox["r", "2"]}]}], 
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"]}]], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8152242030120583`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"25612497-bad6-48f8-a5ba-a16c4b1f869f"]
}, Open  ]],

Cell["This can also be displayed in matrix form:", "Text",ExpressionUUID->"15af27fd-d4ee-4d11-835b-a79ff7f2ecbf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inversemetric", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"9962c654-97bf-4e29-9d05-c656a41f482d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox["r", "2"]}]}], 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"]], "0", "0", "0"},
     {"0", 
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"R", "[", "t", "]"}], "2"]}]], "0", "0"},
     {"0", "0", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"R", "[", "t", "]"}], "2"]}]], "0"},
     {"0", "0", "0", 
      RowBox[{"-", "1"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.815224216361362*^9},
 CellLabel->
  "Out[8]//MatrixForm=",ExpressionUUID->"daea1827-322f-461c-873b-\
b82090a9a302"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the Christoffel symbols:", "Subsubsection",ExpressionUUID->"d733be0e-5299-4456-a395-68caa9c8c047"],

Cell[TextData[{
 "The calculation of the components of the Christoffel symbols is done by \
transcribing the definition given earlier into the notation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions ",
 StyleBox["D",
  FontWeight->"Bold"],
 " for taking partial derivatives, ",
 StyleBox["Sum",
  FontWeight->"Bold"],
 " for summing over repeated indices, ",
 StyleBox["Table",
  FontWeight->"Bold"],
 " for forming a list of components, and ",
 StyleBox["Simplify",
  FontWeight->"Bold"],
 " for simplifying the result."
}], "Text",ExpressionUUID->"e328a263-3fed-4246-b112-2585f3ce8bbc"],

Cell[BoxData[
 RowBox[{"affine", ":=", 
  RowBox[{"affine", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], "*", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"inversemetric", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "s"}], "]"}], "]"}], ")"}], "*", 
          "\[IndentingNewLine]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"s", ",", "j"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "k", "]"}], "]"}]}], " ", "]"}], "+", 
            "\[IndentingNewLine]", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"s", ",", "k"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "j", "]"}], "]"}]}], " ", "]"}], "-", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"metric", "[", 
               RowBox[{"[", 
                RowBox[{"j", ",", "k"}], "]"}], "]"}], ",", 
              RowBox[{"coord", "[", 
               RowBox[{"[", "s", "]"}], "]"}]}], " ", "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
    "]"}]}]}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"1933eba3-6cb2-4ac2-b613-8d086fe72e25"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying the Christoffel symbols:", "Subsubsection",ExpressionUUID->"540daf6d-7c28-42b2-9c23-34c19baaa952"],

Cell[TextData[{
 "The nonzero Christoffel symbols are displayed below. You need not follow \
the details of constructing the functions that we use for that purpose.  In \
the output the symbol \[CapitalGamma][1,2,3] stands for",
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["\[CapitalGamma]", "1"], "23"], TraditionalForm]],
  ExpressionUUID->"6914aea2-32ae-4314-9633-03ade786abc1"],
 ". Because the Christoffel symbols are symmetric under interchange of the \
last two indices, only the independent components are displayed."
}], "Text",ExpressionUUID->"7dfd5506-8676-413f-8fe3-d6ca4d4bfe3f"],

Cell[BoxData[
 RowBox[{"listaffine", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"affine", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", "0"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", 
        RowBox[{"affine", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    " ", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "j"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"23b768c7-9e00-4cc6-a773-16c8e6d9454b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listaffine", "]"}], ",", "Null"}], "]"}], ",",
      "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"309788aa-043a-44c2-93df-056ae437b8e1"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\[CapitalGamma][1, 1, 1]\"\>", 
     FractionBox["r", 
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"\[CapitalGamma][1, 2, 2]\"\>", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"]}]}], ")"}]}]},
    {"\<\"\[CapitalGamma][1, 3, 3]\"\>", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["r", "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]},
    {"\<\"\[CapitalGamma][1, 4, 1]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["R", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], 
      RowBox[{"R", "[", "t", "]"}]]},
    {"\<\"\[CapitalGamma][2, 2, 1]\"\>", 
     FractionBox["1", "r"]},
    {"\<\"\[CapitalGamma][2, 3, 3]\"\>", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
    {"\<\"\[CapitalGamma][2, 4, 2]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["R", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], 
      RowBox[{"R", "[", "t", "]"}]]},
    {"\<\"\[CapitalGamma][3, 3, 1]\"\>", 
     FractionBox["1", "r"]},
    {"\<\"\[CapitalGamma][3, 3, 2]\"\>", 
     RowBox[{"Cot", "[", "\[Theta]", "]"}]},
    {"\<\"\[CapitalGamma][3, 4, 3]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["R", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], 
      RowBox[{"R", "[", "t", "]"}]]},
    {"\<\"\[CapitalGamma][4, 1, 1]\"\>", 
     FractionBox[
      RowBox[{
       RowBox[{"R", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["R", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"\[CapitalGamma][4, 2, 2]\"\>", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"R", "[", "t", "]"}], " ", 
      RowBox[{
       SuperscriptBox["R", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]},
    {"\<\"\[CapitalGamma][4, 3, 3]\"\>", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"R", "[", "t", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["R", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[1.4]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableSpacing -> {2, 2}]]]], "Output",
 CellChangeTimes->{3.815224271836362*^9},
 CellLabel->
  "Out[12]//TableForm=",ExpressionUUID->"d7d253d5-7897-4ceb-9050-\
e455393301e4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating and displaying the Riemann tensor:", "Subsubsection",ExpressionUUID->"72ed670d-3c2e-49f8-95bc-bbf5ade91a99"],

Cell[TextData[{
 "The components of the Riemann tensor, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["R", "\[Lambda]"], "\[Mu]\[Nu]\[Sigma]"], 
   TraditionalForm]],ExpressionUUID->"03745152-0e45-473e-ab8b-080a7dcb7e02"],
 ", are calculated using the definition given above."
}], "Text",ExpressionUUID->"0b111ee4-6fa3-4f3b-b868-7bbbaa1ec798"],

Cell[BoxData[
 RowBox[{"riemann", ":=", 
  RowBox[{"riemann", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"affine", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j", ",", "l"}], "]"}], "]"}], ",", 
         RowBox[{"coord", "[", 
          RowBox[{"[", "k", "]"}], "]"}]}], " ", "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"affine", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", 
         RowBox[{"coord", "[", 
          RowBox[{"[", "l", "]"}], "]"}]}], " ", "]"}], "+", 
       "\[IndentingNewLine]", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"affine", "[", 
            RowBox[{"[", 
             RowBox[{"s", ",", "j", ",", "l"}], "]"}], "]"}], " ", 
           RowBox[{"affine", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "k", ",", "s"}], "]"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"affine", "[", 
            RowBox[{"[", 
             RowBox[{"s", ",", "j", ",", "k"}], "]"}], "]"}], " ", 
           RowBox[{"affine", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "l", ",", "s"}], "]"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
    "]"}]}]}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"04040438-0887-4ff9-9dd9-acf5bd5cffd1"],

Cell[TextData[{
 "The nonzero components are displayed by the following functions. In the \
output, the symbol R[1, 2, 1, 3] stands for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["R", "1"], "213"], TraditionalForm]],ExpressionUUID->
  "0d2ca59f-2cfe-4ed8-b14c-293ae6413b71"],
 ", and similarly for the other components.",
 " You can obtain R[1, 2, 3, 1] from R[1, 2, 1, 3] using the antisymmetry of \
the Riemann tensor under exchange of the last two indices. The antisymmetry \
under exchange of the first two indices of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "\[Lambda]\[Mu]\[Nu]\[Sigma]"], TraditionalForm]],
  ExpressionUUID->"9e79ac93-0122-4660-b3e5-a4fefbf3c5e5"],
 " is not evident in the output because the components of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SuperscriptBox["R", "\[Lambda]"], "\[Mu]\[Nu]\[Sigma]"], 
   TraditionalForm]],ExpressionUUID->"3c8503c9-39fc-45f8-b5f2-f281d2f1cc3a"],
 " are displayed."
}], "Text",ExpressionUUID->"7fd57c7c-fa20-46bf-a4bb-9283920ccf59"],

Cell[BoxData[
 RowBox[{"listriemann", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"riemann", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "]"}], "]"}], ",", 
        "0"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"R", "[", 
          RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "]"}], "]"}], ",", 
        RowBox[{"riemann", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "]"}], "]"}]}], 
       "}"}]}], "]"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", 
      RowBox[{"k", "-", "1"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"b1724c06-8c46-411d-8dd2-d17ceb8ad1c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listriemann", "]"}], ",", "Null"}], "]"}], 
     ",", "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"d4880e4f-542c-4748-92a2-51fbfeda707e"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"R[1, 2, 2, 1]\"\>", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["R", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}]]}]},
    {"\<\"R[1, 3, 3, 1]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["R", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[1, 3, 3, 2]\"\>", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["r", "3"]}], " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
    {"\<\"R[1, 4, 4, 1]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["R", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], 
      RowBox[{"R", "[", "t", "]"}]]},
    {"\<\"R[2, 1, 2, 1]\"\>", 
     FractionBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["R", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[2, 3, 3, 2]\"\>", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["r", "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["R", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], ")"}]}]},
    {"\<\"R[2, 4, 4, 2]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["R", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], 
      RowBox[{"R", "[", "t", "]"}]]},
    {"\<\"R[3, 1, 3, 1]\"\>", 
     FractionBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["R", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[3, 2, 3, 2]\"\>", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["R", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], ")"}]}]},
    {"\<\"R[3, 4, 4, 3]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["R", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], 
      RowBox[{"R", "[", "t", "]"}]]},
    {"\<\"R[4, 1, 4, 1]\"\>", 
     FractionBox[
      RowBox[{
       RowBox[{"R", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["R", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[4, 2, 2, 1]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"R", "[", "t", "]"}], " ", 
       RowBox[{
        SuperscriptBox["R", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[4, 2, 4, 2]\"\>", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"R", "[", "t", "]"}], " ", 
      RowBox[{
       SuperscriptBox["R", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]},
    {"\<\"R[4, 3, 3, 1]\"\>", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"R", "[", "t", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["R", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[4, 3, 4, 3]\"\>", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"R", "[", "t", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["R", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[1.4]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableSpacing -> {2, 2}]]]], "Output",
 CellChangeTimes->{3.815224297671369*^9},
 CellLabel->
  "Out[15]//TableForm=",ExpressionUUID->"e916fec2-98b4-4357-aca8-\
3c7a1b352647"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating and displaying the Ricci tensor:", "Subsubsection",ExpressionUUID->"74296700-2c55-49bd-a362-50c30489f58f"],

Cell[TextData[{
 "The Ricci tensor ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "7c8b7702-663a-439a-83e5-1c6001d4064c"],
 " was defined by summing the first and third indices of the Riemann tensor \
(which has the first index already raised)."
}], "Text",ExpressionUUID->"6348dc89-66a7-42cf-8cc8-ec2caf1b28e6"],

Cell[BoxData[
 RowBox[{"ricci", ":=", 
  RowBox[{"ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"riemann", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j", ",", "i", ",", "l"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
    "]"}]}]}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"6163b8c9-9cab-41c2-9a66-c2b2ceb8c069"],

Cell[TextData[{
 "Next we display the nonzero components. In the output, R[1, 2] denotes ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "12"], TraditionalForm]],ExpressionUUID->
  "61c07a70-213e-4726-8b10-21c512747e9f"],
 ", and similarly for the other components."
}], "Text",ExpressionUUID->"dcb001bc-75b0-40d9-803c-85dd2a3b9803"],

Cell[BoxData[
 RowBox[{"listricci", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"ricci", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}], ",", "0"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"R", "[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}], ",", 
        RowBox[{"ricci", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}]}], "}"}]}], "]"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", "j"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"0c83cd0a-3a1f-4e83-993b-cea7400f44c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listricci", "]"}], ",", "Null"}], "]"}], ",", 
     "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"70b66abd-ee79-45ca-9618-a7965c04a91c"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"R[1, 1]\"\>", 
     FractionBox[
      RowBox[{"2", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["R", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"R", "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["R", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[2, 2]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["R", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          RowBox[{"R", "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["R", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[3, 3]\"\>", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["R", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          RowBox[{"R", "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["R", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}]]},
    {"\<\"R[4, 4]\"\>", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{
         SuperscriptBox["R", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], 
       RowBox[{"R", "[", "t", "]"}]]}]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[1.4]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableSpacing -> {2, 2}]]]], "Output",
 CellChangeTimes->{3.8152243261835413`*^9},
 CellLabel->
  "Out[18]//TableForm=",ExpressionUUID->"4d7ba644-d31b-4fbf-80e3-\
5de1ff2e15b4"]
}, Open  ]],

Cell["\<\
A vanishing table (as with the Schwarzschild metric example)  means that the \
vacuum Einstein equation is satisfied.\
\>", "Text",ExpressionUUID->"2b596fb8-febb-4155-8164-a922243a64ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the scalar curvature:", "Subsubsection",ExpressionUUID->"49263813-204d-42de-aa99-fdead3f054d5"],

Cell[TextData[{
 "The scalar curvature ",
 StyleBox["R",
  FontSlant->"Italic"],
 " is calculated using the inverse metric and the Ricci tensor. The result is \
displayed in the output line."
}], "Text",ExpressionUUID->"fa60f508-1a5c-4989-a8aa-94d7fb691d88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"scalar", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"inversemetric", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], 
      RowBox[{"ricci", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}], " ", 
   "]"}]}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"90c8dcd4-1062-46e2-b2e6-af4ba233c4b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "15"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["r", "2"]}], "+", 
    RowBox[{"2", " ", "k", " ", 
     SuperscriptBox["r", "2"]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "k"}], ")"}], " ", 
        SuperscriptBox["r", "2"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["R", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "6"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "k"}], ")"}], " ", 
        SuperscriptBox["r", "2"]}]}], ")"}], " ", 
     RowBox[{"R", "[", "t", "]"}], " ", 
     RowBox[{
      SuperscriptBox["R", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"R", "[", "t", "]"}], "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.815224348565969*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"c70f00ba-66dc-42d6-ba14-0b0aab0d70f1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the Einstein tensor:", "Subsubsection",ExpressionUUID->"88007471-e14b-4b71-b0e0-bab06112b529"],

Cell[TextData[{
 "The Einstein tensor,  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["G", "\[Mu]\[Nu]"], "=", 
    RowBox[{
     SubscriptBox["R", "\[Mu]\[Nu]"], "-", 
     RowBox[{
      FractionBox["1", "2"], 
      SubscriptBox["g", "\[Mu]\[Nu]"], "R"}]}]}], TraditionalForm]],
  ExpressionUUID->"7de18f8f-5975-4ba6-a0ac-475b9637622f"],
 ", is found from the tensors already calculated."
}], "Text",ExpressionUUID->"5138128e-8f42-4418-a07d-1276ccec0a69"],

Cell[BoxData[
 RowBox[{"einstein", ":=", 
  RowBox[{"einstein", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"ricci", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], "scalar", "*", "metric"}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"3d3d0c2b-fab2-4f92-9684-ef2e39e1acb8"],

Cell["\<\
The results are displayed in the same way as for the Ricci tensor earlier.\
\>", "Text",ExpressionUUID->"bc47ccb5-ce62-4a18-9443-695bfd2f153a"],

Cell[BoxData[
 RowBox[{"listeinstein", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"UnsameQ", "[", 
       RowBox[{
        RowBox[{"einstein", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}], ",", "0"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"G", "[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}], ",", 
        RowBox[{"einstein", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "l"}], "]"}], "]"}]}], "}"}]}], "]"}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "n"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", "j"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"d7c81f69-d922-4c4e-a121-7e1465f2eac0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", "listeinstein", "]"}], ",", "Null"}], "]"}], 
     ",", "2"}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"958bf98e-c662-4163-8482-429bafa00b21"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"G[1, 1]\"\>", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"11", "-", 
        RowBox[{"10", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", "k", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "k"}], ")"}], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["R", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5"}], "+", "k"}], ")"}], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"R", "[", "t", "]"}], " ", 
         RowBox[{
          SuperscriptBox["R", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"k", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}]]}]},
    {"\<\"G[2, 2]\"\>", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "k", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"k", " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["R", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", "k"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], " ", 
           RowBox[{"R", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["R", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}]]}]},
    {"\<\"G[3, 3]\"\>", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "k", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"k", " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["R", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", "k"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], " ", 
           RowBox[{"R", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["R", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}]]}]},
    {"\<\"G[4, 4]\"\>", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "15"}], "+", 
       RowBox[{"10", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"2", " ", "k", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "+", "k"}], ")"}], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["R", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"R", "[", "t", "]"}], " ", 
        RowBox[{
         SuperscriptBox["R", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"]}]]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[1.4]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.8]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableSpacing -> {2, 2}]]]], "Output",
 CellChangeTimes->{3.815224378914898*^9},
 CellLabel->
  "Out[22]//TableForm=",ExpressionUUID->"41183a1d-2464-4f92-a1de-\
5c04465864e7"]
}, Open  ]],

Cell["\<\
A vanishing table means that the vacuum Einstein equation is satisfied!\
\>", "Text",ExpressionUUID->"425785f2-4e86-4a18-9022-e626b23df6b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Acknowledgment", "Subsubsection",ExpressionUUID->"4c0a0c52-b041-47da-bceb-4f0061cf4878"],

Cell[TextData[{
 "This program was kindly written by ",
 StyleBox["Leonard Parker, University of Wisconsin, Milwaukee ",
  FontSlant->"Italic"],
 StyleBox["especially ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["for this text. ",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",ExpressionUUID->"de2a8ae7-a1a5-43ac-aea2-c56de7d482c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "=", 
  RowBox[{"Expand", 
   RowBox[{"(", 
    RowBox[{"G", "[", 
     RowBox[{"1", ",", "1"}], "]"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.815224463488573*^9, 3.815224491341672*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"9f4b2679-0a6f-4e5c-858c-413cd4493884"],

Cell[BoxData[
 RowBox[{"Expand", " ", 
  RowBox[{"G", "[", 
   RowBox[{"1", ",", "1"}], "]"}]}]], "Output",
 CellChangeTimes->{3.81522449330443*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"21a9b11c-0ae3-4971-978e-ab9626833d3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.815224575713936*^9, 3.815224586424981*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"b74738ae-9931-4fdc-8eb9-1b8a9a948089"],

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.8152245878733053`*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"615ff28a-44aa-439c-814b-d5cea8307e81"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"G", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.815224636737916*^9, 3.815224682093068*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"8549be8f-a379-49f1-90a8-d3c1ca7eb2c7"],

Cell[BoxData[
 RowBox[{"G", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.8152246839544153`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"e78a8f1f-290e-4ed3-8a04-73a3e61885c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"R", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.8152247402967377`*^9, 3.8152247457993*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"b4e5fc46-482b-4145-b530-137a3792bdd3"],

Cell[BoxData[
 RowBox[{"R", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.815224748445266*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"d7c1f644-9830-4634-8c0a-82f0907ad283"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"R", "[", 
   RowBox[{"1", ",", "1"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.815224786962489*^9, 3.8152247916262417`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"0b6c87b7-f81b-4d1a-bd20-c7aeb347919c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"R", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[28]:=",ExpressionUUID->"061f5454-296e-4880-97d2-38d73cdb2e6a"],

Cell[BoxData[
 RowBox[{"R", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.815224796330914*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"13f6387e-6672-4bcb-aca7-409aacb24282"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ricci", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.815224886615617*^9, 3.815224892167288*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"f6a8ff13-51e7-49c1-ac1e-ea2efdc76cb4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{"2", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["R", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
        RowBox[{
         RowBox[{"R", "[", "t", "]"}], " ", 
         RowBox[{
          SuperscriptBox["R", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}]], 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["R", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"R", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["R", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], ",", 
      "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}]], 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["R", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"R", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["R", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], ",", 
      "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["R", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], 
        RowBox[{"R", "[", "t", "]"}]]}]}], "}"}]}], "}"}], "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.815224893254952*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"72ec6f53-237f-439b-91b2-41405175f562"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"einstein", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.815224899181041*^9, 3.8152249376742897`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"cd72f368-cee5-45a9-ae04-702dc14d1d79"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"11", "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "k", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "k"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["R", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "5"}], "+", "k"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"R", "[", "t", "]"}], " ", 
            RowBox[{
             SuperscriptBox["R", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"k", " ", 
              SuperscriptBox["r", "2"]}]}], ")"}]}], ")"}]}], ")"}]}], ",", 
      "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]], 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "k", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"k", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["R", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"3", "+", "k"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"R", "[", "t", "]"}], " ", 
            RowBox[{
             SuperscriptBox["R", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], ",",
       "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"-", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]], 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "k", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"k", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["R", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"3", "+", "k"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"R", "[", "t", "]"}], " ", 
            RowBox[{
             SuperscriptBox["R", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], ",",
       "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "15"}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "k", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "+", "k"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["R", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"R", "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["R", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"R", "[", "t", "]"}], "2"]}], ")"}]}]}], "}"}]}], "}"}], 
  "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.815224938593492*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"76d77698-dcb8-4aca-9d99-c99d475ac22d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{"einstein", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.81522494676847*^9, 3.8152249688476477`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"361e5d83-522d-4906-8094-5d82b25834af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"11", "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "k", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "k"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["R", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "5"}], "+", "k"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"R", "[", "t", "]"}], " ", 
            RowBox[{
             SuperscriptBox["R", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"k", " ", 
              SuperscriptBox["r", "2"]}]}], ")"}]}], ")"}]}], ")"}]}], ",", 
      "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]], 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "k", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"k", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["R", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"3", "+", "k"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"R", "[", "t", "]"}], " ", 
            RowBox[{
             SuperscriptBox["R", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], ",",
       "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"-", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]], 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "k", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"k", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["R", "\[Prime]",
               MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"3", "+", "k"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"R", "[", "t", "]"}], " ", 
            RowBox[{
             SuperscriptBox["R", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}]}], ",",
       "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "15"}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "k", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "+", "k"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["R", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "k"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"R", "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["R", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"R", "[", "t", "]"}], "2"]}], ")"}]}]}], "}"}]}], "}"}], 
  "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.8152249702031193`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"de06775a-9242-4d5a-bba9-a2cdff41b73f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"ricci", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.815225045728265*^9, 3.815225064686405*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"bc2dfbbf-3028-41f0-b035-946b3caeb551"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{"2", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["R", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
        RowBox[{
         RowBox[{"R", "[", "t", "]"}], " ", 
         RowBox[{
          SuperscriptBox["R", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}]], 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["R", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"R", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["R", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], ",", 
      "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}]], 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["R", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"R", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["R", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], ",", 
      "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["R", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], 
        RowBox[{"R", "[", "t", "]"}]]}]}], "}"}]}], "}"}], "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.815225067613015*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"5e0a6f7c-852f-4d89-ac6e-95f3eedaf8aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["ricci11"], "Input",
 CellChangeTimes->{{3.8152250850874367`*^9, 3.81522508976338*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"288305df-d6ca-4e06-b422-60d418fe4682"],

Cell[BoxData["ricci11"], "Output",
 CellChangeTimes->{3.8152250911894903`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"99cd430d-3c85-4b67-b84f-30bcf2c7e791"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["metric"], "Input",
 CellChangeTimes->{{3.815225275571876*^9, 3.815225276591989*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"fbf3ab28-17ac-4e2c-8b8c-2a7449bf9061"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"], 
      RowBox[{"1", "-", 
       RowBox[{"k", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", "0"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.81522528225721*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"e3a66ae6-b8e0-4805-a202-caa5d9e01950"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"], 
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0", ",", "0"}], "}"}],
     ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"]}], ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]], "Input",
 NumberMarks->False,
 CellLabel->"In[35]:=",ExpressionUUID->"2cc3bd6a-2906-45a1-9dd0-b6044ec4a7b0"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"], 
      RowBox[{"1", "-", 
       RowBox[{"k", " ", 
        SuperscriptBox["r", "2"]}]}]], "0", "0", "0"},
    {"0", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"]}], "0", "0"},
    {"0", "0", 
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"R", "[", "t", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "0"},
    {"0", "0", "0", 
     RowBox[{"-", "1"}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.815225292764165*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"582f2966-3e27-45df-ae83-7b22ff04dcf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.8152253323538647`*^9, 3.815225339086265*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"50fd16d9-3072-4256-8382-1110cf92917f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"], 
       RowBox[{"1", "-", 
        RowBox[{"k", " ", 
         SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0", ",", "0"}], "}"}],
     ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"]}], ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"R", "[", "t", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}], "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 CellChangeTimes->{3.815225340724874*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"5979fc66-6e43-4ced-93fb-2221cc76ef1c"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.815225346775999*^9, 
  3.815225356592065*^9}},ExpressionUUID->"fc111763-9472-47ec-85ba-\
997c97f1fee7"]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{770, 614},
WindowMargins->{{Automatic, 119}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792},
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "home", "hartle", 
   "131book", "math", "Curvature"}, "curvature-n.ps1", CharacterEncoding -> 
  "ISO8859-1"]},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d982bbef-e9da-4414-bc16-9d2b11e2a1b2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 110, 0, 79, "Subtitle",ExpressionUUID->"681884af-d099-4c9c-be96-4b19990a64b0"],
Cell[693, 24, 814, 22, 160, "Text",ExpressionUUID->"8eeec01f-c40f-45cf-b3b7-dd770d446c55"],
Cell[1510, 48, 787, 22, 59, "Text",ExpressionUUID->"aa593a8f-60e1-432e-89c8-99d19be7a3a8"],
Cell[2300, 72, 547, 16, 54, "Text",ExpressionUUID->"a01dbbf2-2b29-4d9b-be54-781019e685be"],
Cell[2850, 90, 1058, 30, 55, "Text",ExpressionUUID->"681b7e12-835c-48a6-8eda-140dc2c57975"],
Cell[3911, 122, 87, 0, 53, "Text",ExpressionUUID->"81735623-702a-4c97-9fcd-76253c5a493b"],
Cell[4001, 124, 330, 9, 55, "Text",ExpressionUUID->"b231510a-66fc-4af5-9a47-82da105a76f8"],
Cell[4334, 135, 92, 0, 53, "Text",ExpressionUUID->"6a551bb7-969c-452d-91e4-9eb4f5c5b8fd"],
Cell[4429, 137, 309, 9, 55, "Text",ExpressionUUID->"262dbed1-4f5f-46c3-8817-7e296e7f3a80"],
Cell[4741, 148, 95, 0, 53, "Text",ExpressionUUID->"d0d7b2c6-b050-44dd-a79d-ba54734c7fb6"],
Cell[4839, 150, 403, 13, 59, "Text",ExpressionUUID->"d60636b9-8054-4868-a8de-414b28a12a3d"],
Cell[5245, 165, 732, 16, 228, "Text",ExpressionUUID->"1773f22f-cea2-4bc8-aa98-56b2d0c464fd"],
Cell[CellGroupData[{
Cell[6002, 185, 111, 0, 67, "Subsubsection",ExpressionUUID->"9f5a6ef0-adf2-4fba-aeb4-021a354a5212"],
Cell[6116, 187, 260, 4, 122, "Text",ExpressionUUID->"7d0e8339-e9f3-4f1d-9754-d6beeedd951f"],
Cell[6379, 193, 429, 8, 78, "Input",ExpressionUUID->"3f23962c-e4ab-4904-9efe-f89b3aadcc36"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6845, 206, 102, 0, 67, "Subsubsection",ExpressionUUID->"d5c45351-ca56-4ea7-b9ab-8d440f4ff021"],
Cell[6950, 208, 238, 6, 53, "Text",ExpressionUUID->"da3c1d8f-3ceb-450d-b259-2e0536da70d1"],
Cell[CellGroupData[{
Cell[7213, 218, 127, 2, 46, "Input",ExpressionUUID->"db3a41b7-a756-4e63-ad81-90175bd0e2ab"],
Cell[7343, 222, 148, 2, 52, "Output",ExpressionUUID->"5e051290-32c7-4d48-85dd-dda3457f7135"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7540, 230, 111, 0, 67, "Subsubsection",ExpressionUUID->"d9841b60-61c3-41f3-a2c2-c8df0937af70"],
Cell[7654, 232, 229, 3, 122, "Text",ExpressionUUID->"357a1e0e-0226-48f4-aa2d-646cb6893c94"],
Cell[CellGroupData[{
Cell[7908, 239, 257, 6, 46, "Input",ExpressionUUID->"891d6a60-eeda-4738-9f99-5056205e18d8"],
Cell[8168, 247, 225, 4, 52, "Output",ExpressionUUID->"9117a4d4-5d0d-47e9-9e7d-7bb5da9872bc"]
}, Open  ]],
Cell[8408, 254, 994, 29, 192, "Text",ExpressionUUID->"cf00d67d-f382-49ed-a196-51492a0bcdf6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9439, 288, 100, 0, 67, "Subsubsection",ExpressionUUID->"7c1e4ef5-3a88-48f0-ad1c-941fc3d699f5"],
Cell[9542, 290, 255, 4, 122, "Text",ExpressionUUID->"60ced2c8-e6cb-4e11-ae01-d72d962d75d5"],
Cell[CellGroupData[{
Cell[9822, 298, 1438, 41, 140, "Input",ExpressionUUID->"c69a98ec-7b6d-461e-8ca5-69fd4e23751a"],
Cell[11263, 341, 1022, 31, 117, "Output",ExpressionUUID->"3489848f-2a38-4c07-8474-632c2155c402"]
}, Open  ]],
Cell[12300, 375, 112, 0, 53, "Text",ExpressionUUID->"7a087d8f-64d7-42c9-98ff-b4930521bcbb"],
Cell[CellGroupData[{
Cell[12437, 379, 142, 2, 46, "Input",ExpressionUUID->"3c9305aa-7730-46cb-a360-eaf25559a445"],
Cell[12582, 383, 1210, 38, 168, "Output",ExpressionUUID->"0cc1961b-9c2a-45ce-9ac9-04a56fa65bf0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13841, 427, 85, 0, 67, "Subsubsection",ExpressionUUID->"b1eec755-c696-460c-9424-ae5f0986b6a2"],
Cell[13929, 429, 1254, 40, 295, "Text",ExpressionUUID->"a698725a-17ed-4ad0-84f6-426373867323"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15220, 474, 111, 0, 67, "Subsubsection",ExpressionUUID->"8934d8f1-f052-426b-b4ec-d0d8c7cf6c47"],
Cell[15334, 476, 127, 0, 53, "Text",ExpressionUUID->"59eb44bf-5d9b-4eed-815e-a98c1a8dea84"],
Cell[CellGroupData[{
Cell[15486, 480, 214, 4, 46, "Input",ExpressionUUID->"79e36277-db93-4b1d-ac0c-feb037bfab03"],
Cell[15703, 486, 1047, 33, 141, "Output",ExpressionUUID->"25612497-bad6-48f8-a5ba-a16c4b1f869f"]
}, Open  ]],
Cell[16765, 522, 113, 0, 53, "Text",ExpressionUUID->"15af27fd-d4ee-4d11-835b-a79ff7f2ecbf"],
Cell[CellGroupData[{
Cell[16903, 526, 149, 2, 46, "Input",ExpressionUUID->"9962c654-97bf-4e29-9d05-c656a41f482d"],
Cell[17055, 530, 1259, 40, 200, "Output",ExpressionUUID->"daea1827-322f-461c-873b-b82090a9a302"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18363, 576, 116, 0, 67, "Subsubsection",ExpressionUUID->"d733be0e-5299-4456-a395-68caa9c8c047"],
Cell[18482, 578, 678, 21, 226, "Text",ExpressionUUID->"e328a263-3fed-4246-b112-2585f3ce8bbc"],
Cell[19163, 601, 1877, 51, 295, "Input",ExpressionUUID->"1933eba3-6cb2-4ac2-b613-8d086fe72e25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21077, 657, 115, 0, 67, "Subsubsection",ExpressionUUID->"540daf6d-7c28-42b2-9c23-34c19baaa952"],
Cell[21195, 659, 649, 13, 228, "Text",ExpressionUUID->"7dfd5506-8676-413f-8fe3-d6ca4d4bfe3f"],
Cell[21847, 674, 943, 27, 140, "Input",ExpressionUUID->"23b768c7-9e00-4cc6-a773-16c8e6d9454b"],
Cell[CellGroupData[{
Cell[22815, 705, 443, 12, 109, "Input",ExpressionUUID->"309788aa-043a-44c2-93df-056ae437b8e1"],
Cell[23261, 719, 3055, 90, 588, "Output",ExpressionUUID->"d7d253d5-7897-4ceb-9050-e455393301e4"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26365, 815, 126, 0, 67, "Subsubsection",ExpressionUUID->"72ed670d-3c2e-49f8-95bc-bbf5ade91a99"],
Cell[26494, 817, 362, 8, 90, "Text",ExpressionUUID->"0b111ee4-6fa3-4f3b-b868-7bbbaa1ec798"],
Cell[26859, 827, 1917, 52, 233, "Input",ExpressionUUID->"04040438-0887-4ff9-9dd9-acf5bd5cffd1"],
Cell[28779, 881, 1033, 23, 265, "Text",ExpressionUUID->"7fd57c7c-fa20-46bf-a4bb-9283920ccf59"],
Cell[29815, 906, 1065, 30, 140, "Input",ExpressionUUID->"b1724c06-8c46-411d-8dd2-d17ceb8ad1c8"],
Cell[CellGroupData[{
Cell[30905, 940, 444, 12, 109, "Input",ExpressionUUID->"d4880e4f-542c-4748-92a2-51fbfeda707e"],
Cell[31352, 954, 5613, 172, 754, "Output",ExpressionUUID->"e916fec2-98b4-4357-aca8-3c7a1b352647"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37014, 1132, 124, 0, 67, "Subsubsection",ExpressionUUID->"74296700-2c55-49bd-a362-50c30489f58f"],
Cell[37141, 1134, 367, 8, 124, "Text",ExpressionUUID->"6348dc89-66a7-42cf-8cc8-ec2caf1b28e6"],
Cell[37511, 1144, 658, 18, 171, "Input",ExpressionUUID->"6163b8c9-9cab-41c2-9a66-c2b2ceb8c069"],
Cell[38172, 1164, 335, 7, 89, "Text",ExpressionUUID->"dcb001bc-75b0-40d9-803c-85dd2a3b9803"],
Cell[38510, 1173, 813, 23, 140, "Input",ExpressionUUID->"0c83cd0a-3a1f-4e83-993b-cea7400f44c0"],
Cell[CellGroupData[{
Cell[39348, 1200, 442, 12, 109, "Input",ExpressionUUID->"70b66abd-ee79-45ca-9618-a7965c04a91c"],
Cell[39793, 1214, 3350, 101, 250, "Output",ExpressionUUID->"4d7ba644-d31b-4fbf-80e3-5de1ff2e15b4"]
}, Open  ]],
Cell[43158, 1318, 196, 3, 88, "Text",ExpressionUUID->"2b596fb8-febb-4155-8164-a922243a64ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43391, 1326, 113, 0, 67, "Subsubsection",ExpressionUUID->"49263813-204d-42de-aa99-fdead3f054d5"],
Cell[43507, 1328, 258, 6, 88, "Text",ExpressionUUID->"fa60f508-1a5c-4989-a8aa-94d7fb691d88"],
Cell[CellGroupData[{
Cell[43790, 1338, 584, 17, 109, "Input",ExpressionUUID->"90c8dcd4-1062-46e2-b2e6-af4ba233c4b5"],
Cell[44377, 1357, 1310, 42, 90, "Output",ExpressionUUID->"c70f00ba-66dc-42d6-ba14-0b0aab0d70f1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45736, 1405, 112, 0, 67, "Subsubsection",ExpressionUUID->"88007471-e14b-4b71-b0e0-bab06112b529"],
Cell[45851, 1407, 470, 13, 94, "Text",ExpressionUUID->"5138128e-8f42-4418-a07d-1276ccec0a69"],
Cell[46324, 1422, 332, 9, 78, "Input",ExpressionUUID->"3d3d0c2b-fab2-4f92-9684-ef2e39e1acb8"],
Cell[46659, 1433, 153, 2, 88, "Text",ExpressionUUID->"bc47ccb5-ce62-4a18-9443-695bfd2f153a"],
Cell[46815, 1437, 822, 23, 140, "Input",ExpressionUUID->"d7c81f69-d922-4c4e-a121-7e1465f2eac0"],
Cell[CellGroupData[{
Cell[47662, 1464, 445, 12, 109, "Input",ExpressionUUID->"958bf98e-c662-4163-8482-429bafa00b21"],
Cell[48110, 1478, 5828, 173, 298, "Output",ExpressionUUID->"41183a1d-2464-4f92-a1de-5c04465864e7"]
}, Open  ]],
Cell[53953, 1654, 150, 2, 88, "Text",ExpressionUUID->"425785f2-4e86-4a18-9022-e626b23df6b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54140, 1661, 94, 0, 67, "Subsubsection",ExpressionUUID->"4c0a0c52-b041-47da-bceb-4f0061cf4878"],
Cell[54237, 1663, 393, 10, 88, "Text",ExpressionUUID->"de2a8ae7-a1a5-43ac-aea2-c56de7d482c4"],
Cell[CellGroupData[{
Cell[54655, 1677, 297, 7, 46, "Input",ExpressionUUID->"9f4b2679-0a6f-4e5c-858c-413cd4493884"],
Cell[54955, 1686, 227, 5, 52, "Output",ExpressionUUID->"21a9b11c-0ae3-4971-978e-ab9626833d3d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55219, 1696, 222, 4, 46, "Input",ExpressionUUID->"b74738ae-9931-4fdc-8eb9-1b8a9a948089"],
Cell[55444, 1702, 201, 4, 52, "Output",ExpressionUUID->"615ff28a-44aa-439c-814b-d5cea8307e81"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55682, 1711, 283, 6, 46, "Input",ExpressionUUID->"8549be8f-a379-49f1-90a8-d3c1ca7eb2c7"],
Cell[55968, 1719, 201, 4, 52, "Output",ExpressionUUID->"e78a8f1f-290e-4ed3-8a04-73a3e61885c2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56206, 1728, 222, 4, 46, "Input",ExpressionUUID->"b4e5fc46-482b-4145-b530-137a3792bdd3"],
Cell[56431, 1734, 199, 4, 52, "Output",ExpressionUUID->"d7c1f644-9830-4634-8c0a-82f0907ad283"]
}, Open  ]],
Cell[56645, 1741, 243, 5, 46, "Input",ExpressionUUID->"0b6c87b7-f81b-4d1a-bd20-c7aeb347919c"],
Cell[CellGroupData[{
Cell[56913, 1750, 177, 4, 46, "Input",ExpressionUUID->"061f5454-296e-4880-97d2-38d73cdb2e6a"],
Cell[57093, 1756, 199, 4, 52, "Output",ExpressionUUID->"13f6387e-6672-4bcb-aca7-409aacb24282"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57329, 1765, 226, 4, 46, "Input",ExpressionUUID->"f6a8ff13-51e7-49c1-ac1e-ea2efdc76cb4"],
Cell[57558, 1771, 3384, 100, 254, "Output",ExpressionUUID->"72ec6f53-237f-439b-91b2-41405175f562"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60979, 1876, 292, 6, 46, "Input",ExpressionUUID->"cd72f368-cee5-45a9-ae04-702dc14d1d79"],
Cell[61274, 1884, 6208, 178, 480, "Output",ExpressionUUID->"76d77698-dcb8-4aca-9d99-c99d475ac22d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67519, 2067, 289, 6, 46, "Input",ExpressionUUID->"361e5d83-522d-4906-8094-5d82b25834af"],
Cell[67811, 2075, 6210, 178, 480, "Output",ExpressionUUID->"de06775a-9242-4d5a-bba9-a2cdff41b73f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74058, 2258, 287, 6, 46, "Input",ExpressionUUID->"bc2dfbbf-3028-41f0-b035-946b3caeb551"],
Cell[74348, 2266, 3384, 100, 254, "Output",ExpressionUUID->"5e0a6f7c-852f-4d89-ac6e-95f3eedaf8aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77769, 2371, 179, 2, 46, "Input",ExpressionUUID->"288305df-d6ca-4e06-b422-60d418fe4682"],
Cell[77951, 2375, 157, 2, 52, "Output",ExpressionUUID->"99cd430d-3c85-4b67-b84f-30bcf2c7e791"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78145, 2382, 177, 2, 46, "Input",ExpressionUUID->"fbf3ab28-17ac-4e2c-8b8c-2a7449bf9061"],
Cell[78325, 2386, 998, 31, 117, "Output",ExpressionUUID->"e3a66ae6-b8e0-4805-a202-caa5d9e01950"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79360, 2422, 1036, 32, 118, "Input",ExpressionUUID->"2cc3bd6a-2906-45a1-9dd0-b6044ec4a7b0"],
Cell[80399, 2456, 882, 28, 151, "Output",ExpressionUUID->"582f2966-3e27-45df-ae83-7b22ff04dcf8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81318, 2489, 229, 4, 46, "Input",ExpressionUUID->"50fd16d9-3072-4256-8382-1110cf92917f"],
Cell[81550, 2495, 1078, 33, 117, "Output",ExpressionUUID->"5979fc66-6e43-4ced-93fb-2221cc76ef1c"]
}, Open  ]],
Cell[82643, 2531, 152, 3, 46, "Input",ExpressionUUID->"fc111763-9472-47ec-85ba-997c97f1fee7"]
}, Open  ]]
}, Open  ]]
}
]
*)

